/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.annotation.TargetApi;
import android.net.Uri;
import android.text.TextUtils;
import android.util.LruCache;
import android.webkit.CookieManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.cosmos.mdlog.MDLog;
import com.immomo.mmdns.MDDNSEntrance;
import com.immomo.mmdns.MMOkHttpDns;
import com.immomo.mmdns.MomoMainThreadExecutor;
import com.immomo.mmdns.SNISocketFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.conn.ssl.AbstractVerifier;

public class WebDNSHandler {
    static OkHttpClient client = new OkHttpClient.Builder().readTimeout(10L, TimeUnit.SECONDS).connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).followRedirects(false).eventListener((EventListener)new WebDnsEventListener()).dns((Dns)new MMOkHttpDns()).build();

    @TargetApi(value=21)
    public static WebResourceResponse handleInterceptRequest(WebView webView, WebResourceRequest webRequest) {
        return WebDNSHandler.handleInterceptRequest(null, webView, webRequest);
    }

    @TargetApi(value=21)
    public static WebResourceResponse handleInterceptRequest(byte[] postData, WebView view, WebResourceRequest request) {
        try {
            Uri requestUri = request.getUrl();
            String url = requestUri.toString();
            if (url.contains(".mp4") || url.contains(".mp3")) {
                MDLog.e((String)"MMDNS", (String)"this url not support DNS \u2014\u2014\u2014\u2014> mp4 or mp3 %s", (Object[])new Object[]{url});
                return null;
            }
            if (!WebDNSHandler.isSupportDns(requestUri.getHost())) {
                MDLog.e((String)"MMDNS", (String)"this url not support DNS \u2014\u2014\u2014\u2014> no config %s", (Object[])new Object[]{url});
                return null;
            }
            String method = request.getMethod();
            Map headerFields = request.getRequestHeaders();
            String scheme = requestUri.getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme) || !method.equalsIgnoreCase("get")) {
                MDLog.e((String)"MMDNS", (String)"this url not support DNS \u2014\u2014\u2014\u2014> non http/get %s", (Object[])new Object[]{url});
                return null;
            }
            StringBuilder currentAP = new StringBuilder();
            Response response = WebDNSHandler.recursiveRequest(postData, view, url, headerFields, currentAP);
            if (!response.isSuccessful()) {
                MDLog.e((String)"MMDNS", (String)"this url not support DNS \u2014\u2014\u2014\u2014> response failed %d, %s", (Object[])new Object[]{response.code(), url});
                return null;
            }
            ResponseBody body = response.body();
            String contentType = null;
            if (body != null && null != body.contentType()) {
                contentType = body.contentType().toString();
            }
            String mime = WebDNSHandler.getMime(contentType);
            String charset = WebDNSHandler.getCharset(contentType);
            Set headerKeySet = response.headers().names();
            if (WebDNSHandler.containCookie(headerKeySet)) {
                List cookies = response.headers("Set-Cookie");
                for (String tmpCookie : cookies) {
                    CookieManager.getInstance().setCookie(requestUri.getHost(), tmpCookie);
                }
            }
            WebResourceResponse resourceResponse = new WebResourceResponse(mime, TextUtils.isEmpty((CharSequence)charset) ? "UTF-8" : charset, body.byteStream());
            resourceResponse.setStatusCodeAndReasonPhrase(response.code() == 304 ? 200 : response.code(), "OK");
            HashMap<String, String> responseHeader = new HashMap<String, String>(response.headers().size());
            for (String key : headerKeySet) {
                List values = response.headers(key);
                if (values.size() <= 0) continue;
                StringBuilder builder = new StringBuilder();
                if (values.size() > 1) {
                    int index = 0;
                    for (String value : values) {
                        builder.append(value);
                        if (index != values.size() - 1) {
                            builder.append(";");
                        }
                        ++index;
                    }
                } else {
                    builder.append((String)values.get(0));
                }
                responseHeader.put(key, builder.toString());
            }
            resourceResponse.setResponseHeaders(responseHeader);
            WebDNSHandler.recordFailed(currentAP, true);
            return resourceResponse;
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
            return null;
        }
    }

    public static String getLocationUrl(byte[] postData, String path) throws Exception {
        Request.Builder builder;
        URL url = new URL(path);
        String originHost = url.getHost();
        MDLog.d((String)"MMDNS", (String)("getLocationUrl Url: " + path));
        if (null != postData) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (byte[])postData);
            builder = new Request.Builder().post(body).url(url);
        } else {
            builder = new Request.Builder().get().url(url);
        }
        WebDNSHandler.addHeaders(builder, null, originHost);
        Request request = builder.build();
        Response response = client.newCall(request).execute();
        int code = response.code();
        if (WebDNSHandler.needRedirect(code)) {
            String location = response.header("Location");
            if (location == null) {
                location = response.header("location");
            }
            if (location != null) {
                if (!location.startsWith("http://") && !location.startsWith("https://")) {
                    location = url.getProtocol() + "://" + originHost + location;
                }
                String finalLocation = location;
                MDLog.e((String)"MMDNS", (String)("code:" + code + "; location:" + location + "; path:" + path));
                Uri locationUri = Uri.parse((String)location);
                WebDNSHandler.setCookie(response, locationUri.getHost());
                return finalLocation;
            }
            throw new RuntimeException("cannot get location");
        }
        throw new RuntimeException("cannot get location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response recursiveRequest(byte[] postData, final WebView webView, String path, Map<String, String> headers, StringBuilder currentAP) throws Exception {
        Request.Builder builder;
        URL url = new URL(path);
        String originHost = url.getHost();
        if (null != postData) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (byte[])postData);
            builder = new Request.Builder().post(body).url(url);
        } else {
            builder = new Request.Builder().get().url(url);
        }
        WebDNSHandler.addHeaders(builder, headers, originHost);
        Request request = builder.build();
        Response response = client.newCall(request).execute();
        int code = response.code();
        if (WebDNSHandler.needRedirect(code)) {
            String location = response.header("Location");
            if (location == null) {
                location = response.header("Location");
            }
            if (location != null) {
                if (!location.startsWith("http://") && !location.startsWith("https://")) {
                    location = url.getProtocol() + "://" + originHost + location;
                }
                final String finalLocation = location;
                MDLog.e((String)"MMDNS", (String)("code:" + code + "; location:" + location + "; path:" + path));
                Uri locationUri = Uri.parse((String)location);
                WebDNSHandler.setCookie(response, locationUri.getHost());
                final Object lock = new Object();
                String contentType = response.body().contentType().toString();
                Object object = lock;
                synchronized (object) {
                    if (!TextUtils.isEmpty((CharSequence)contentType) && contentType.contains("html") && !TextUtils.equals((CharSequence)locationUri.getPath(), (CharSequence)url.getPath())) {
                        MomoMainThreadExecutor.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (null != webView) {
                                    webView.loadUrl("javascript:window.location.replace(\"" + finalLocation + "\")");
                                    Object object = lock;
                                    synchronized (object) {
                                        lock.notifyAll();
                                    }
                                }
                            }
                        });
                        lock.wait(3000L);
                    }
                }
                return WebDNSHandler.recursiveRequest(null, webView, location, headers, currentAP);
            }
            throw new RuntimeException("cannot get location");
        }
        WebDNSHandler.setCookie(response, originHost);
        return response;
    }

    private static void addHeaders(Request.Builder builder, Map<String, String> headers, String originHost) {
        String cookie;
        if (null != headers) {
            for (Map.Entry<String, String> field : headers.entrySet()) {
                builder.addHeader(field.getKey(), field.getValue());
            }
        }
        if (!(null != headers && headers.containsKey("Cookie") || TextUtils.isEmpty((CharSequence)(cookie = CookieManager.getInstance().getCookie(originHost))))) {
            builder.addHeader("Cookie", cookie);
        }
    }

    private static boolean isSupportDns(String host) {
        return MDDNSEntrance.getInstance().useDNS(host);
    }

    private static boolean needRedirect(int code) {
        return code != 304 && code >= 300 && code < 400;
    }

    private static void setCookie(Response response, String host) {
        List cookies = response.headers("Set-Cookie");
        for (String tmpCookie : cookies) {
            CookieManager.getInstance().setCookie(host, tmpCookie);
        }
    }

    private static void recordFailed(StringBuilder builder, boolean success) {
        String[] ipPorts;
        String apStr;
        if (null != builder && !TextUtils.isEmpty((CharSequence)(apStr = builder.toString())) && (ipPorts = apStr.split(":")).length > 1) {
            if (success) {
                MDDNSEntrance.getInstance().requestSucceedForDomain(ipPorts[0], ipPorts[1]);
            } else {
                MDDNSEntrance.getInstance().requestFailedForDomain(ipPorts[0], ipPorts[1]);
            }
        }
    }

    private static String getMime(String contentType) {
        if (contentType == null) {
            return null;
        }
        return contentType.split(";")[0];
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        String[] fields = contentType.split(";");
        if (fields.length <= 1) {
            return null;
        }
        String charset = fields[1];
        if (!charset.contains("=")) {
            return null;
        }
        charset = charset.substring(charset.indexOf("=") + 1);
        return charset;
    }

    private static boolean containCookie(Set<String> headerKeySet) {
        if (null != headerKeySet) {
            for (String key : headerKeySet) {
                if (TextUtils.isEmpty((CharSequence)key) || !key.contains("Cookie")) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static String getLocationUrlByUrlConnection(byte[] postData, String path) throws Exception {
        int code;
        URL url = new URL(path);
        String originHost = url.getHost();
        String ip = MDDNSEntrance.getInstance().getUsableHost(originHost);
        String newUrl = path.replaceFirst(originHost, ip);
        MDLog.d((String)"MMDNS", (String)("oldUrl: " + path + " newUrl: " + newUrl + " from HTTPDNS successfully!"));
        HttpURLConnection conn = (HttpURLConnection)new URL(newUrl).openConnection();
        String cookie = CookieManager.getInstance().getCookie(originHost);
        if (!TextUtils.isEmpty((CharSequence)cookie)) {
            conn.setRequestProperty("Cookie", cookie);
        }
        conn.setRequestProperty("Host", originHost);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setInstanceFollowRedirects(false);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conn;
            String host = conn.getRequestProperty("Host");
            SNISocketFactory sslSocketFactory = new SNISocketFactory(host, null, null);
            sslSocketFactory.enableConfigureTlsExtensions();
            httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
            httpsURLConnection.setHostnameVerifier((HostnameVerifier)((Object)new MyHostnameVerifier(originHost)));
        }
        if (null != postData) {
            conn.setRequestMethod("POST");
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(postData);
        }
        if (WebDNSHandler.needRedirect(code = conn.getResponseCode())) {
            String location = conn.getHeaderField("Location");
            if (location == null) {
                location = conn.getHeaderField("location");
            }
            if (location != null) {
                if (!location.startsWith("http://") && !location.startsWith("https://")) {
                    location = url.getProtocol() + "://" + originHost + location;
                }
                String finalLocation = location;
                MDLog.e((String)"MMDNS", (String)("code:" + code + "; location:" + location + "; path:" + path));
                Uri locationUri = Uri.parse((String)location);
                WebDNSHandler.setCookie(conn, locationUri.getHost());
                return finalLocation;
            }
            throw new RuntimeException("cannot get location");
        }
        throw new RuntimeException("cannot get location");
    }

    private static void setCookie(HttpURLConnection conn, String host) {
        List<String> cookies = conn.getHeaderFields().get("Set-Cookie");
        if (null != cookies) {
            for (String tmpCookie : cookies) {
                CookieManager.getInstance().setCookie(host, tmpCookie);
            }
        }
    }

    private static class MyHostnameVerifier
    extends AbstractVerifier {
        private String originHost;

        MyHostnameVerifier(String host) {
            this.originHost = host;
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            try {
                if (!TextUtils.isEmpty((CharSequence)this.originHost)) {
                    this.verify(this.originHost, cns, subjectAlts, true);
                } else {
                    this.verify(host, cns, subjectAlts, true);
                }
                MDLog.e((String)"MMDNS", (String)"WebDNSHandler ip %s -> host %s", (Object[])new Object[]{host, this.originHost});
            }
            catch (SSLException e) {
                MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e, (String)"WebDNSHandler host=%s, cns=%s, subjectAlts=%s", (Object[])new Object[]{host, Arrays.toString(cns), Arrays.toString(subjectAlts)});
                throw e;
            }
        }
    }

    private static class WebDnsEventListener
    extends EventListener {
        private LruCache<String, String> requestRecords = new LruCache(100);
        private final Object lock = new Object();

        private WebDnsEventListener() {
        }

        public void dnsStart(Call call, String domainName) {
            MDLog.i((String)"MMDNS", (String)"dnsStart call %s domainName:%s", (Object[])new Object[]{call, domainName});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
            MDLog.i((String)"MMDNS", (String)"dnsEnd call %s domainName:%s AddressList:%s", (Object[])new Object[]{call, domainName, inetAddressList});
            if (WebDNSHandler.isSupportDns(domainName) && null != inetAddressList && inetAddressList.size() > 0) {
                String ip = inetAddressList.get(0).getHostAddress();
                Object object = this.lock;
                synchronized (object) {
                    this.requestRecords.put((Object)(domainName + ";" + call.hashCode()), (Object)ip);
                }
            }
        }

        public void callFailed(Call call, IOException ioe) {
            MDLog.i((String)"MMDNS", (String)"callFailed call %s exception:%s ", (Object[])new Object[]{call, ioe});
            this.recordFailed(call);
        }

        public void responseHeadersEnd(Call call, Response response) {
            int code = response.code();
            if (code != 404 && code >= 400 && code <= 599) {
                this.recordFailed(call);
            } else if (code >= 200 && code <= 299) {
                this.recordSuccess(call);
            }
        }

        public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
            super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
            MDLog.i((String)"MMDNS", (String)"connectFailed call %s");
            this.recordFailed(call);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordFailed(Call call) {
            block5: {
                try {
                    String ip;
                    String host = call.request().url().host();
                    if (!WebDNSHandler.isSupportDns(host)) break block5;
                    Object object = this.lock;
                    synchronized (object) {
                        ip = (String)this.requestRecords.remove((Object)(host + ";" + call.hashCode()));
                    }
                    MDDNSEntrance.getInstance().requestFailedForDomain(host, ip);
                }
                catch (Exception e) {
                    MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordSuccess(Call call) {
            block5: {
                try {
                    String ip;
                    String host = call.request().url().host();
                    if (!WebDNSHandler.isSupportDns(host)) break block5;
                    Object object = this.lock;
                    synchronized (object) {
                        ip = (String)this.requestRecords.remove((Object)(host + ";" + call.hashCode()));
                    }
                    MDDNSEntrance.getInstance().requestSucceedForDomain(host, ip);
                }
                catch (Exception e) {
                    MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
                }
            }
        }
    }
}

