/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.cosmos.mdlog.MDLog;
import com.immomo.mmdns.DNSLogger;
import com.immomo.mmdns.MDDNSEntrance;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;

public abstract class IMDDNSConfig {
    private DNSLogger logger;

    public abstract String getAppId();

    public abstract String getVersion();

    public abstract String getUid();

    public abstract String getLng();

    public abstract String getLat();

    public abstract String getUserAgent();

    public String getKeyStoreSha1() {
        try {
            PackageInfo info = MDDNSEntrance.sContext.getPackageManager().getPackageInfo(MDDNSEntrance.sContext.getPackageName(), 64);
            byte[] cert = info.signatures[0].toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(cert);
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < publicKey.length; ++i) {
                String appendString = Integer.toHexString(0xFF & publicKey[i]).toUpperCase(Locale.US);
                if (appendString.length() == 1) {
                    hexString.append("0");
                }
                hexString.append(appendString);
                hexString.append(":");
            }
            String result = hexString.toString();
            return result.substring(0, result.length() - 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    public abstract String getDefaultLocalDNSConfigs();

    public String getDocumentBasePath() {
        File dir = MDDNSEntrance.sContext.getFilesDir();
        File cacheDir = new File(dir, "mmdns_cache");
        if (!cacheDir.exists()) {
            cacheDir.mkdir();
        }
        return cacheDir.getAbsolutePath() + File.separator;
    }

    public String getIMDefaultHost() {
        return "";
    }

    public int getIMDefaultPort() {
        return 0;
    }

    public abstract boolean isNetworkAvailable();

    public abstract String getNetworkType();

    public void setDnsLogger(DNSLogger logger) {
        this.logger = logger;
    }

    public void triggerEventLog(String eventName, Map<String, String> eventInfo) {
        MDLog.e((String)"MMDNS", (String)"eventName:%s eventInfo:%s", (Object[])new Object[]{eventName, eventInfo});
        if (null != this.logger) {
            try {
                long time = Long.parseLong(eventInfo.get("time"));
                this.logger.recordRequestLog(eventInfo.get("dn"), eventInfo.get("requestIp"), time);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

