/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import com.cosmos.mdlog.MDLog;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DNSUtils {
    static boolean isIPHost(String host) {
        String regex = "(?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))";
        Pattern mPattern = null;
        mPattern = Pattern.compile(regex);
        Matcher matcher = mPattern.matcher(host);
        return matcher.matches();
    }

    public static String getCurrentProcessName(Context sContext) {
        if (sContext == null) {
            return null;
        }
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)sContext.getSystemService("activity");
        if (mActivityManager == null) {
            return null;
        }
        List appProcesses = null;
        try {
            appProcesses = mActivityManager.getRunningAppProcesses();
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        if (appProcesses == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return null;
    }
}

