/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.immomo.mmdns.DNSUtils;
import com.immomo.mmdns.IMDDNSConfig;
import com.immomo.mmdns.MDDNSEntrance;
import java.util.HashMap;
import java.util.Map;

public class DNSManager {
    private static Map<String, MDDNSEntrance> entranceMap = new HashMap<String, MDDNSEntrance>(2);

    public static void setLibraryLoader(MDDNSEntrance.LibraryLoader libraryLoader) {
        MDDNSEntrance.setLibraryLoader(libraryLoader);
    }

    public static void init(Context context, IMDDNSConfig config) {
        DNSManager.init(context, config, null);
    }

    public static synchronized void init(Context context, IMDDNSConfig config, String processName) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new RuntimeException("please call init in main thread");
        }
        if (TextUtils.isEmpty((CharSequence)config.getAppId())) {
            throw new RuntimeException("please fill your appId in IMDDNSConfig imp");
        }
        MDDNSEntrance dnsEntrance = new MDDNSEntrance();
        if (TextUtils.isEmpty((CharSequence)processName)) {
            processName = DNSUtils.getCurrentProcessName(context);
        }
        processName = config.getAppId() + "-" + processName;
        dnsEntrance.initDNSConfig(context, config, processName);
        dnsEntrance.openAll(true);
        entranceMap.put(config.getAppId(), dnsEntrance);
    }

    public static synchronized void destroy(String appId) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new RuntimeException("please call destory in main thread");
        }
        MDDNSEntrance dnsEntrance = entranceMap.remove(appId);
        if (null != dnsEntrance) {
            dnsEntrance.destroy();
        }
    }

    public static synchronized MDDNSEntrance getInstance(String appId) {
        if (!entranceMap.containsKey(appId)) {
            throw new RuntimeException("please call DNSManager#init first");
        }
        return entranceMap.get(appId);
    }
}

