/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.text.TextUtils;
import com.cosmos.mdlog.MDLog;
import com.immomo.mmdns.DNSUtils;
import com.immomo.mmdns.MDDNSEntrance;
import com.immomo.mmdns.SNISocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLFactoryUtils {
    public static SSLSocketFactory getSslSocketFactory(InputStream bksFile, String password, String requestHost, String originHost, InputStream ... certificates) {
        MDLog.i((String)"MMDNS", (String)("getSslSocketFactory " + requestHost + " - " + originHost + " - "));
        try {
            KeyManager[] keyManagers = SSLFactoryUtils.prepareKeyManager(bksFile, password);
            TrustManager[] trustManagers = SSLFactoryUtils.prepareTrustManager(certificates);
            X509TrustManager trustManager = trustManagers != null ? new MyTrustManager(SSLFactoryUtils.chooseTrustManager(trustManagers)) : new UnSafeTrustManager();
            if (!TextUtils.isEmpty((CharSequence)requestHost) && DNSUtils.isIPHost(requestHost) && MDDNSEntrance.getInstance().useDNS(originHost)) {
                return new SNISocketFactory(originHost, new TrustManager[]{trustManager}, keyManagers);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Object[] getSslSocketFactoryAndTrustManager(InputStream bksFile, String password, String requestHost, String originHost, InputStream ... certificates) {
        MDLog.i((String)"MMDNS", (String)("getSslSocketFactoryAndTrustManager " + requestHost + " - " + originHost + " - "));
        try {
            KeyManager[] keyManagers = SSLFactoryUtils.prepareKeyManager(bksFile, password);
            TrustManager[] trustManagers = SSLFactoryUtils.prepareTrustManager(certificates);
            X509TrustManager trustManager = trustManagers != null ? new MyTrustManager(SSLFactoryUtils.chooseTrustManager(trustManagers)) : new UnSafeTrustManager();
            if (!TextUtils.isEmpty((CharSequence)requestHost) && DNSUtils.isIPHost(requestHost) && MDDNSEntrance.getInstance().useDNS(originHost)) {
                return new Object[]{new SNISocketFactory(originHost, new TrustManager[]{trustManager}, keyManagers), trustManager};
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            return new Object[]{sslContext.getSocketFactory(), trustManager};
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyStoreException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static TrustManager[] prepareTrustManager(InputStream ... certificates) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = null;
            if (certificates != null && certificates.length > 0) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null);
                int index = 0;
                for (InputStream certificate : certificates) {
                    String certificateAlias = Integer.toString(index++);
                    keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
                    try {
                        if (certificate == null) continue;
                        certificate.close();
                    }
                    catch (IOException e) {
                        MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
                    }
                }
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (CertificateException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (KeyStoreException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        return null;
    }

    private static KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            clientKeyStore.load(bksFile, password.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (CertificateException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (IOException e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
        }
        return null;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager defaultTrustManager;
        private X509TrustManager localTrustManager;

        public MyTrustManager(X509TrustManager localTrustManager) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory var4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            var4.init((KeyStore)null);
            this.defaultTrustManager = SSLFactoryUtils.chooseTrustManager(var4.getTrustManagers());
            this.localTrustManager = localTrustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                this.localTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class UnSafeTrustManager
    implements X509TrustManager {
        private UnSafeTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

