/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Build;
import com.cosmos.mdlog.MDLog;
import com.immomo.mmdns.MDDNSEntrance;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.internal.connection.RealConnection;

public class SNISocketFactory
extends SSLSocketFactory
implements RealConnection.WithSniInfo {
    private String peerHost;
    private TrustManager[] trustManager;
    private KeyManager[] mKeyManagers;
    private boolean configureTlsExtensions = false;

    void enableConfigureTlsExtensions() {
        this.configureTlsExtensions = true;
    }

    public SNISocketFactory(String peerHost, TrustManager[] trustManager, KeyManager[] keyManagers) {
        this.peerHost = peerHost;
        this.trustManager = trustManager;
        this.mKeyManagers = keyManagers;
    }

    @Override
    public Socket createSocket(Socket plainSocket, String host, int port, boolean autoClose) throws IOException {
        if (this.peerHost == null) {
            this.peerHost = host;
        }
        MDLog.d((String)"MMDNS", (String)("customized createSocket. host: " + this.peerHost));
        InetAddress address = plainSocket.getInetAddress();
        if (autoClose) {
            plainSocket.close();
        }
        SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0, (SSLSessionCache)MDDNSEntrance.getSslSessionCache());
        if (null != this.trustManager) {
            sslSocketFactory.setTrustManagers(this.trustManager);
        }
        if (null != this.mKeyManagers) {
            sslSocketFactory.setKeyManagers(this.mKeyManagers);
        }
        SSLSocket ssl = (SSLSocket)sslSocketFactory.createSocket(address, port);
        ssl.setEnabledProtocols(ssl.getSupportedProtocols());
        if (this.configureTlsExtensions) {
            if (Build.VERSION.SDK_INT >= 17) {
                sslSocketFactory.setHostname((Socket)ssl, this.peerHost);
            } else {
                try {
                    Method setHostnameMethod = ssl.getClass().getMethod("setHostname", String.class);
                    setHostnameMethod.invoke((Object)ssl, this.peerHost);
                }
                catch (Exception e) {
                    MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
                }
            }
            SSLSession session = ssl.getSession();
            if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(this.peerHost, session)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: " + this.peerHost);
            }
        }
        return ssl;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public Socket createSocket() throws IOException {
        return super.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return null;
    }

    public String getSniHostname() {
        return this.peerHost;
    }
}

