/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.cosmos.mdlog.MDLog;
import com.immomo.mmdns.MomoMainThreadExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetUtil {
    public static Context context;
    private static final String TAG = "NetUtil";
    private static long lastTime;
    private static List<Long> receiverList;
    private static BroadcastReceiver netChangeBroadcastReceiver;

    public static void init(Context context) {
        lastTime = System.currentTimeMillis();
        if (context != null && NetUtil.context == null) {
            NetUtil.context = context.getApplicationContext();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(netChangeBroadcastReceiver, filter);
        }
    }

    static int getNetType() {
        if (context != null) {
            try {
                ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
                if (activeNetInfo != null) {
                    int networkType = activeNetInfo.getType();
                    if (networkType == 1) {
                        return 4;
                    }
                    networkType = activeNetInfo.getSubtype();
                    switch (networkType) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            return 1;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            return 2;
                        }
                        case 13: {
                            return 3;
                        }
                    }
                    return 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    static boolean isNetworkAvailable() {
        if (context == null) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
            return true;
        }
    }

    static void registerNetChangeReceiver(long receiver) {
        receiverList.add(receiver);
        MDLog.i((String)"MMDNS", (String)"registerNetChangeReceiver");
    }

    static void unregisterNetChangeReceiver(long receiver) {
        if (receiverList.contains(receiver)) {
            receiverList.remove(receiver);
        }
        MDLog.i((String)"MMDNS", (String)"unregisterNetChangeReceiver");
    }

    protected static void clearAllReceivers() {
        receiverList.clear();
    }

    private static native void nativeNotifyNetChanged(long var0);

    static {
        receiverList = Collections.synchronizedList(new ArrayList());
        netChangeBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (context == null || intent == null) {
                    return;
                }
                if (System.currentTimeMillis() - lastTime < 5000L) {
                    return;
                }
                if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                    MomoMainThreadExecutor.cancelAllRunnables("dnsNetChanged");
                    MomoMainThreadExecutor.postDelayed("dnsNetChanged", new Runnable(){

                        @Override
                        public void run() {
                            try {
                                this.onNetworkChange();
                            }
                            catch (Exception e) {
                                Log.i((String)NetUtil.TAG, (String)"getActiveNetworkInfo failed.");
                            }
                        }
                    }, 3000L);
                }
            }

            private void onNetworkChange() {
                try {
                    for (int i = receiverList.size() - 1; i >= 0; --i) {
                        MDLog.e((String)"MMDNS", (String)"onNetworkChange");
                        NetUtil.nativeNotifyNetChanged((Long)receiverList.get(i));
                    }
                }
                catch (Throwable e) {
                    Log.i((String)NetUtil.TAG, (String)"nativeNotifyNetChanged failed.");
                }
            }
        };
    }
}

