/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.content.Context;
import android.net.SSLSessionCache;
import android.text.TextUtils;
import com.cosmos.mdlog.MDLog;
import com.cosmos.mdlog.XLogImpl;
import com.immomo.mmdns.DNSLogger;
import com.immomo.mmdns.DNSUtils;
import com.immomo.mmdns.IMDDNSConfig;
import com.immomo.mmdns.NetUtil;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

public class MDDNSEntrance {
    private boolean openAll;
    @Deprecated
    public static Map<String, String> ipHostMap = new ConcurrentHashMap<String, String>(20);
    private String appId;
    public static Context sContext;
    private static SSLSessionCache sslSessionCache;
    private boolean stackDebug;
    private DNSLogger dnsLogger;
    private static MDDNSEntrance instance;
    private static LibraryLoader libraryLoader;
    private final Set<String> whiteHostSet = new HashSet<String>();
    private boolean openDNS = false;
    private ForegroundGetter foregroundGetter;

    MDDNSEntrance() {
        this.dnsLogger = new DNSLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDDNSEntrance getInstance() {
        Class<MDDNSEntrance> clazz = MDDNSEntrance.class;
        synchronized (MDDNSEntrance.class) {
            if (instance == null) {
                instance = new MDDNSEntrance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static SSLSessionCache getSslSessionCache() {
        return sslSessionCache;
    }

    private void loadSharedLibs() {
        if (libraryLoader != null) {
            try {
                libraryLoader.loadLibrary("mmdns");
            }
            catch (UnsatisfiedLinkError e) {
                MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
            }
        } else {
            try {
                System.loadLibrary("mmdns");
            }
            catch (UnsatisfiedLinkError e) {
                MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
            }
        }
    }

    public static void setLibraryLoader(LibraryLoader libraryLoader) {
        MDDNSEntrance.libraryLoader = libraryLoader;
    }

    public void openDNS(boolean toggle) {
        this.openDNS = toggle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteHostList(Set<String> set) {
        if (null != set) {
            Set<String> set2 = this.whiteHostSet;
            synchronized (set2) {
                this.whiteHostSet.clear();
                this.whiteHostSet.addAll(set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useDNS(String host) {
        if (this.openAll) {
            return true;
        }
        if (!this.openDNS) {
            return false;
        }
        Set<String> set = this.whiteHostSet;
        synchronized (set) {
            return this.whiteHostSet.contains(host);
        }
    }

    public void openAll(boolean toggle) {
        this.openAll = toggle;
    }

    public void initDNSConfig(Context context, IMDDNSConfig config) {
        this.initDNSConfig(context, config, DNSUtils.getCurrentProcessName(context));
    }

    public void initDNSConfig(Context context, IMDDNSConfig config, String processName) {
        config.setDnsLogger(this.dnsLogger);
        this.appId = config.getAppId();
        this.loadSharedLibs();
        sContext = context;
        sslSessionCache = new SSLSessionCache(context);
        NetUtil.init(context);
        if (config != null) {
            this.nativeInitDNSConfig(config, processName, this.appId);
        }
        this.openDNS = true;
    }

    public void openDebug(String logDir) {
        XLogImpl.open((boolean)true, (int)0, (String)logDir, (String)logDir, (String)"mdlog_");
        MDLog.setLogImp((MDLog.LogImp)new XLogImpl());
        MDLog.setConsoleLogOpen((boolean)true);
        MDLog.setLevel((int)0);
    }

    public void closeDebug() {
        MDLog.setConsoleLogOpen((boolean)false);
        MDLog.setLevel((int)7);
    }

    public void openStackDebug(boolean stackDebug) {
        this.stackDebug = stackDebug;
        MDLog.setOpenStackInfo((boolean)true);
    }

    public synchronized String getUsableHost(String domain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)domain)) {
            return domain;
        }
        long beginTime = System.currentTimeMillis();
        String ip = this.nativeGetUsableHost(domain, this.appId);
        MDLog.i((String)"MMDNS", (String)"replace %s \u2014\u2014> %s", (Object[])new Object[]{domain, ip});
        ipHostMap.put(ip, domain);
        this.dnsLogger.recordDnsResult(System.currentTimeMillis() - beginTime, domain, ip);
        return ip;
    }

    public synchronized String[] getUsableHostList(String domain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)domain)) {
            String[] ipList = new String[]{domain};
            return ipList;
        }
        String[] ipList = this.nativeGetUsableHostList(domain, this.appId);
        return ipList;
    }

    public synchronized String getUsableHostFromUrl(String url) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        String host = null;
        try {
            host = new URL(url).getHost();
            long beginTime = System.currentTimeMillis();
            String replaceHost = this.nativeGetUsableHost(host, this.appId);
            MDLog.i((String)"MMDNS", (String)"replace %s \u2014\u2014> %s", (Object[])new Object[]{host, replaceHost});
            ipHostMap.put(replaceHost, host);
            this.dnsLogger.recordDnsResult(System.currentTimeMillis() - beginTime, host, replaceHost);
            return replaceHost;
        }
        catch (Exception exception) {
            return host;
        }
    }

    public synchronized String getUseableURL(String url) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            String host = new URL(url).getHost();
            long beginTime = System.currentTimeMillis();
            String replaceHost = this.nativeGetUsableHost(host, this.appId);
            if (!TextUtils.equals((CharSequence)host, (CharSequence)replaceHost)) {
                String replaceUrl = url.replaceFirst(host, replaceHost);
                MDLog.i((String)"MMDNS", (String)"replace %s \u2014\u2014> %s", (Object[])new Object[]{url, replaceUrl});
                ipHostMap.put(replaceHost, host);
                this.dnsLogger.recordDnsResult(System.currentTimeMillis() - beginTime, host, replaceHost);
                return replaceUrl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public void requestSucceedForDomain(String mainDomain, String successedDomain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)mainDomain) || TextUtils.isEmpty((CharSequence)successedDomain)) {
            return;
        }
        MDLog.i((String)"MMDNS", (String)"Success For Domain %s \u2014\u2014> %s", (Object[])new Object[]{mainDomain, successedDomain});
        this.nativeRequestSucceedForDomain(mainDomain, successedDomain, this.appId);
    }

    public void requestFailedForDomain(String mainDomain, String failedDomain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)mainDomain) || TextUtils.isEmpty((CharSequence)failedDomain)) {
            return;
        }
        if (this.stackDebug) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)new Exception());
        }
        MDLog.e((String)"MMDNS", (String)"Failed For Domain %s \u2014\u2014> %s", (Object[])new Object[]{mainDomain, failedDomain});
        this.nativeRequestFailedForDomain(mainDomain, failedDomain, this.appId);
    }

    public void requestSucceedForOriURL(String oriURL, String successedDomain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)oriURL) || TextUtils.isEmpty((CharSequence)successedDomain)) {
            return;
        }
        try {
            String host = new URL(oriURL).getHost();
            this.requestSucceedForDomain(host, successedDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestFailedForOriURL(String oriURL, String failedDomain) {
        if (!this.openDNS || TextUtils.isEmpty((CharSequence)oriURL) || TextUtils.isEmpty((CharSequence)failedDomain)) {
            return;
        }
        if (this.stackDebug) {
            MDLog.printErrStackTrace((String)"MMDNS", (Throwable)new Exception());
        }
        try {
            String host = new URL(oriURL).getHost();
            MDLog.e((String)"MMDNS", (String)"Failed For Domain %s \u2014\u2014> %s", (Object[])new Object[]{host, failedDomain});
            this.requestFailedForDomain(host, failedDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIMUsableAP() {
        String ap = this.nativeGetImUsableAP(this.appId);
        if (TextUtils.isEmpty((CharSequence)ap)) {
            return "ap.immomo.com:443";
        }
        return ap;
    }

    public void onIMConnectSuccess(String ip, int port) {
        this.nativeImConnectSuccessed(ip, port, this.appId);
    }

    public void onImConnectFailed(String ip, int port) {
        this.nativeImConnectFailed(ip, port, this.appId);
    }

    public void storeNextAP(String domain, int port) {
        this.nativeImStoreAP(domain, port, this.appId);
    }

    public void storeNextAps(List<String> aps) {
        if (null == aps) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < aps.size(); ++i) {
            if (i == aps.size() - 1) {
                builder.append(aps.get(i));
                continue;
            }
            builder.append(aps.get(i)).append(",");
        }
        this.nativeImStoreAps(builder.toString(), this.appId);
    }

    public void setClearHttpDNSCacheSwitch(boolean open) {
        this.nativeSwitchClearHttpDNSCache(open, this.appId);
    }

    public void setRequestEnv(int env) {
        this.nativeSetEnv(env, this.appId);
    }

    public void destroy() {
        this.nativeDestroy(this.appId);
    }

    private native void nativeInitDNSConfig(IMDDNSConfig var1, String var2, String var3);

    private native String nativeGetUsableHost(String var1, String var2);

    private native void nativeRequestSucceedForDomain(String var1, String var2, String var3);

    private native String[] nativeGetUsableHostList(String var1, String var2);

    private native void nativeRequestFailedForDomain(String var1, String var2, String var3);

    private native String nativeGetImUsableAP(String var1);

    private native void nativeImConnectFailed(String var1, int var2, String var3);

    private native void nativeImStoreAP(String var1, int var2, String var3);

    private native void nativeImStoreAps(String var1, String var2);

    private native void nativeImConnectSuccessed(String var1, int var2, String var3);

    private native void nativeSwitchClearHttpDNSCache(boolean var1, String var2);

    private native void nativeSetEnv(int var1, String var2);

    private native void nativeDestroy(String var1);

    public void setForegroundGetter(ForegroundGetter foregroundGetter) {
        this.foregroundGetter = foregroundGetter;
    }

    boolean isForeGround() {
        if (null != this.foregroundGetter) {
            return this.foregroundGetter.isForeGround();
        }
        return true;
    }

    public void setUploadLogger(final ILogger iLogger) {
        this.dnsLogger.setLogCallback(new DNSLogger.LogCallback(){

            @Override
            public void onLogOverflow(String business, JSONArray message) {
                iLogger.upload(business, message);
            }
        });
    }

    static {
        instance = null;
    }

    public static interface ILogger {
        public void upload(String var1, JSONArray var2);
    }

    public static interface ForegroundGetter {
        public boolean isForeGround();
    }

    public static interface LibraryLoader {
        public void loadLibrary(String var1) throws UnsatisfiedLinkError;
    }
}

