/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.mmdns;

import android.text.TextUtils;
import com.cosmos.mdlog.MDLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class DNSLogger {
    private static final String BUSINESS_DNS_PARSETIME = "dns-time";
    private static final String BUSINESS_DNS_RATE = "dns-rate";
    private static final String BUSINESS_DNS_REQUEST = "dns-request";
    private List<ParseLog> parseLogs = new ArrayList<ParseLog>(20);
    private List<RateLog> rateLogs = new ArrayList<RateLog>(20);
    private List<RequestLog> requestLogs = new ArrayList<RequestLog>(20);
    private final Object parseLock = new Object();
    private final Object rateLock = new Object();
    private final Object requestLock = new Object();
    private long smartCount;
    private LogCallback logCallback;

    DNSLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordDnsResult(long time, String host, String ip) {
        if (this.logCallback == null) {
            return;
        }
        if (this.smartCount >= Long.MAX_VALUE) {
            this.smartCount = 0L;
        }
        ++this.smartCount;
        if (this.smartCount % 4L != 0L) {
            return;
        }
        ParseLog log = new ParseLog(host, ip, time);
        Object object = this.parseLock;
        synchronized (object) {
            this.parseLogs.add(log);
            this.processLogUpload(20, this.parseLogs, BUSINESS_DNS_PARSETIME);
        }
        object = this.rateLock;
        synchronized (object) {
            if (TextUtils.equals((CharSequence)host, (CharSequence)ip)) {
                this.rateLogs.add(new RateLog(host, ip, false));
            } else {
                this.rateLogs.add(new RateLog(host, ip, true));
            }
            this.processLogUpload(20, this.rateLogs, BUSINESS_DNS_RATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordRequestLog(String dn, String requestIp, long time) {
        if (this.logCallback == null) {
            return;
        }
        MDLog.e((String)"duanqing", (String)"recordRequestLog: %s %s %d", (Object[])new Object[]{dn, requestIp, time});
        Object object = this.requestLock;
        synchronized (object) {
            this.requestLogs.add(new RequestLog(dn, requestIp, time));
            this.processLogUpload(10, this.requestLogs, BUSINESS_DNS_REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogUpload(int limit, List<? extends Jsonable> list, String business) {
        if (list.size() >= limit) {
            try {
                JSONArray array = new JSONArray();
                for (Jsonable jsonable : list) {
                    array.put((Object)jsonable.toJson());
                }
                this.logCallback.onLogOverflow(business, array);
            }
            catch (Exception e) {
                MDLog.printErrStackTrace((String)"MMDNS", (Throwable)e);
            }
            finally {
                list.clear();
            }
        }
    }

    public void setLogCallback(LogCallback logCallback) {
        this.logCallback = logCallback;
    }

    private static interface Jsonable {
        public JSONObject toJson() throws Exception;
    }

    private class RequestLog
    implements Jsonable {
        String dn;
        String requestIp;
        long time;

        RequestLog(String dn, String requestIp, long time) {
            this.dn = dn;
            this.requestIp = requestIp;
            this.time = time;
        }

        @Override
        public JSONObject toJson() throws Exception {
            JSONObject object = new JSONObject();
            object.put("dn", (Object)this.dn);
            object.put("requestIp", (Object)this.requestIp);
            object.put("time", this.time);
            return object;
        }
    }

    private class RateLog
    implements Jsonable {
        String host;
        String ip;
        boolean success;

        RateLog(String host, String ip, boolean success) {
            this.host = host;
            this.ip = ip;
            this.success = success;
        }

        @Override
        public JSONObject toJson() throws Exception {
            JSONObject object = new JSONObject();
            object.put("host", (Object)this.host);
            object.put("ip", (Object)this.ip);
            object.put("success", this.success);
            return object;
        }
    }

    private class ParseLog
    implements Jsonable {
        public String host;
        public String ip;
        public long time;

        ParseLog(String host, String ip, long time) {
            this.host = host;
            this.ip = ip;
            this.time = time;
        }

        @Override
        public JSONObject toJson() throws Exception {
            JSONObject object = new JSONObject();
            object.put("host", (Object)this.host);
            object.put("ip", (Object)this.ip);
            object.put("time", this.time);
            return object;
        }
    }

    static interface LogCallback {
        public void onLogOverflow(String var1, JSONArray var2);
    }
}

