/*
 * Decompiled with CFR 0.152.
 */
package com.cosmos.apm.framework.page;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import androidx.fragment.app.FragmentManager;
import com.cosmos.apm.framework.page.ActivityLifeCycleCallbackAdapter;
import com.cosmos.apm.framework.page.ActivityLifeCycleHelper;
import com.cosmos.apm.framework.page.AndroidXFragmentLifecycleCallbacksWrapper;
import com.cosmos.apm.framework.page.FragmentLifecycleCallbacks;
import com.cosmos.apm.framework.page.FrameworkFragmentLifecycleCallbacksWrapper;
import com.cosmos.apm.framework.page.SupportFragmentLifecycleCallbacksWrapper;
import java.util.HashSet;
import java.util.Set;

public class FragmentLifeCycleHelper {
    private static Set<FragmentLifecycleCallbacks> sCallbacks = new HashSet<FragmentLifecycleCallbacks>();
    private static FragmentLifecycleCallbacks sFragmentLifecycleCallbacks = new FragmentLifecycleCallbacks(){

        @Override
        public void onFragmentPreAttached(Object fragmentManager, Object fragment, Context context) {
            super.onFragmentPreAttached(fragmentManager, fragment, context);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentPreAttached(fragmentManager, fragment, context);
            }
        }

        @Override
        public void onFragmentAttached(Object fragmentManager, Object fragment, Context context) {
            super.onFragmentAttached(fragmentManager, fragment, context);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentAttached(fragmentManager, fragment, context);
            }
        }

        @Override
        public void onFragmentPreCreated(Object fragmentManager, Object fragment, Bundle savedInstanceState) {
            super.onFragmentPreCreated(fragmentManager, fragment, savedInstanceState);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentPreCreated(fragmentManager, fragment, savedInstanceState);
            }
        }

        @Override
        public void onFragmentCreated(Object fragmentManager, Object fragment, Bundle savedInstanceState) {
            super.onFragmentCreated(fragmentManager, fragment, savedInstanceState);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentCreated(fragmentManager, fragment, savedInstanceState);
            }
        }

        @Override
        public void onFragmentActivityCreated(Object fragmentManager, Object fragment, Bundle savedInstanceState) {
            super.onFragmentActivityCreated(fragmentManager, fragment, savedInstanceState);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentActivityCreated(fragmentManager, fragment, savedInstanceState);
            }
        }

        @Override
        public void onFragmentViewCreated(Object fragmentManager, Object fragment, View v, Bundle savedInstanceState) {
            super.onFragmentViewCreated(fragmentManager, fragment, v, savedInstanceState);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentViewCreated(fragmentManager, fragment, v, savedInstanceState);
            }
        }

        @Override
        public void onFragmentStarted(Object fragmentManager, Object f) {
            super.onFragmentStarted(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentStarted(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentResumed(Object fragmentManager, Object f) {
            super.onFragmentResumed(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentResumed(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentPaused(Object fragmentManager, Object f) {
            super.onFragmentPaused(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentPaused(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentStopped(Object fragmentManager, Object f) {
            super.onFragmentStopped(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentStopped(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentSaveInstanceState(Object fragmentManager, Object fragment, Bundle outState) {
            super.onFragmentSaveInstanceState(fragmentManager, fragment, outState);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentSaveInstanceState(fragmentManager, fragment, outState);
            }
        }

        @Override
        public void onFragmentViewDestroyed(Object fragmentManager, Object f) {
            super.onFragmentViewDestroyed(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentViewDestroyed(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentDestroyed(Object fragmentManager, Object f) {
            super.onFragmentDestroyed(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentDestroyed(fragmentManager, f);
            }
        }

        @Override
        public void onFragmentDetached(Object fragmentManager, Object f) {
            super.onFragmentDetached(fragmentManager, f);
            for (FragmentLifecycleCallbacks callback : sCallbacks) {
                callback.onFragmentDetached(fragmentManager, f);
            }
        }
    };

    public static void registerFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callbacks) {
        sCallbacks.add(callbacks);
    }

    public static void unRegisterFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callbacks) {
        sCallbacks.remove(callbacks);
    }

    static {
        ActivityLifeCycleHelper.registerLifeCycleListener(new ActivityLifeCycleCallbackAdapter(){

            @Override
            public void beforeActivityCreate(Activity activity, Bundle savedInstanceState) {
                if (Build.VERSION.SDK_INT >= 26) {
                    android.app.FragmentManager fragmentManager = activity.getFragmentManager();
                    fragmentManager.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new FrameworkFragmentLifecycleCallbacksWrapper(sFragmentLifecycleCallbacks), true);
                }
                try {
                    for (Class<?> aClass = activity.getClass(); aClass != Object.class && aClass != null; aClass = aClass.getSuperclass()) {
                        String name = aClass.getName();
                        if ("android.support.v4.app.FragmentActivity".equals(name)) {
                            android.support.v4.app.FragmentManager supportFragmentManager = ((FragmentActivity)FragmentActivity.class.cast(activity)).getSupportFragmentManager();
                            supportFragmentManager.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new SupportFragmentLifecycleCallbacksWrapper(sFragmentLifecycleCallbacks), true);
                        } else {
                            if (!"androidx.fragment.app.FragmentActivity".equals(name)) continue;
                            FragmentManager supportFragmentManager = ((androidx.fragment.app.FragmentActivity)androidx.fragment.app.FragmentActivity.class.cast(activity)).getSupportFragmentManager();
                            supportFragmentManager.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new AndroidXFragmentLifecycleCallbacksWrapper(sFragmentLifecycleCallbacks), true);
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

