/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.domain2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DynamicJpaEntityGraphs {
    private DynamicJpaEntityGraphs() {
    }

    public static EntityGraph<?> create(EntityManager entityManager, Class<?> entityType, List<String> attributePaths) {
        EntityGraph jpaEntityGraph = entityManager.createEntityGraph(entityType);
        ArrayList<String> modifiableAttributePaths = new ArrayList<String>(attributePaths);
        Collections.sort(modifiableAttributePaths);
        for (String path : modifiableAttributePaths) {
            String[] pathComponents = StringUtils.delimitedListToStringArray((String)path, (String)".");
            DynamicJpaEntityGraphs.createGraph(pathComponents, 0, jpaEntityGraph, null);
        }
        return jpaEntityGraph;
    }

    private static void createGraph(String[] pathComponents, int offset, EntityGraph<?> root, Subgraph<?> parent) {
        String attributeName = pathComponents[offset];
        if (pathComponents.length - 1 == offset) {
            if (parent == null && !DynamicJpaEntityGraphs.exists(attributeName, root.getAttributeNodes())) {
                root.addAttributeNodes(new String[]{attributeName});
            } else if (parent != null && !DynamicJpaEntityGraphs.exists(attributeName, parent.getAttributeNodes())) {
                parent.addAttributeNodes(new String[]{attributeName});
            }
            return;
        }
        AttributeNode<?> node = DynamicJpaEntityGraphs.findAttributeNode(attributeName, root, parent);
        if (node != null) {
            Subgraph subgraph = DynamicJpaEntityGraphs.getSubgraph(node);
            if (subgraph == null) {
                subgraph = parent != null ? parent.addSubgraph(attributeName) : root.addSubgraph(attributeName);
            }
            DynamicJpaEntityGraphs.createGraph(pathComponents, offset + 1, root, subgraph);
            return;
        }
        if (parent == null) {
            DynamicJpaEntityGraphs.createGraph(pathComponents, offset + 1, root, root.addSubgraph(attributeName));
        } else {
            DynamicJpaEntityGraphs.createGraph(pathComponents, offset + 1, root, parent.addSubgraph(attributeName));
        }
    }

    private static boolean exists(String attributeNodeName, List<AttributeNode<?>> nodes) {
        return DynamicJpaEntityGraphs.findAttributeNode(attributeNodeName, nodes) != null;
    }

    private static AttributeNode<?> findAttributeNode(String attributeNodeName, EntityGraph<?> entityGraph, Subgraph<?> parent) {
        return DynamicJpaEntityGraphs.findAttributeNode(attributeNodeName, parent != null ? parent.getAttributeNodes() : entityGraph.getAttributeNodes());
    }

    private static AttributeNode<?> findAttributeNode(String attributeNodeName, List<AttributeNode<?>> nodes) {
        for (AttributeNode<?> node : nodes) {
            if (!ObjectUtils.nullSafeEquals((Object)node.getAttributeName(), (Object)attributeNodeName)) continue;
            return node;
        }
        return null;
    }

    private static Subgraph<?> getSubgraph(AttributeNode<?> node) {
        return node.getSubgraphs().isEmpty() ? null : (Subgraph)node.getSubgraphs().values().iterator().next();
    }
}

