/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.domain2;

import com.cosium.spring.data.jpa.entity.graph.domain2.DynamicJpaEntityGraphs;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphQueryHint;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;

public class DynamicEntityGraph
implements EntityGraph {
    private final EntityGraphType type;
    private final List<String> attributePaths;

    public DynamicEntityGraph(EntityGraphType type, List<String> attributePaths) {
        this.type = Objects.requireNonNull(type);
        this.attributePaths = Optional.ofNullable(attributePaths).map(ArrayList::new).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public static Builder loading() {
        return DynamicEntityGraph.builder(EntityGraphType.LOAD);
    }

    public static DynamicEntityGraph loading(List<String> attributePaths) {
        return new DynamicEntityGraph(EntityGraphType.LOAD, attributePaths);
    }

    public static Builder fetching() {
        return DynamicEntityGraph.builder(EntityGraphType.FETCH);
    }

    public static DynamicEntityGraph fetching(List<String> attributePaths) {
        return new DynamicEntityGraph(EntityGraphType.FETCH, attributePaths);
    }

    public static Builder builder(EntityGraphType type) {
        return new Builder(type);
    }

    @Override
    public Optional<EntityGraphQueryHint> buildQueryHint(EntityManager entityManager, Class<?> entityType) {
        return Optional.of(new EntityGraphQueryHint(this.type, DynamicJpaEntityGraphs.create(entityManager, entityType, this.attributePaths)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicEntityGraph that = (DynamicEntityGraph)o;
        return this.type == that.type && this.attributePaths.equals(that.attributePaths);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.attributePaths});
    }

    public static class Builder {
        private final EntityGraphType type;
        private final List<String> attributePaths = new ArrayList<String>();

        private Builder(EntityGraphType type) {
            this.type = Objects.requireNonNull(type);
        }

        public Builder addPath(String ... pathParts) {
            this.attributePaths.add(Arrays.stream(pathParts).flatMap(pathPart -> Arrays.stream(pathPart.split("\\."))).collect(Collectors.joining(".")));
            return this;
        }

        public DynamicEntityGraph build() {
            return new DynamicEntityGraph(this.type, this.attributePaths);
        }
    }
}

