/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.openid_connect.mock.server;

import com.cosium.openid_connect.mock.server.Client;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Objects;

class AuthorizationCode {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    final ZonedDateTime authenticationTime = ZonedDateTime.now();
    final String value;
    final Client client;
    final String redirectUri;
    final String nonce;

    AuthorizationCode(Client client, String redirectUri, String nonce) {
        this.client = Objects.requireNonNull(client);
        this.redirectUri = Objects.requireNonNull(redirectUri);
        this.nonce = Objects.requireNonNull(nonce);
        this.value = AuthorizationCode.generateRandomToken();
    }

    private static String generateRandomToken() {
        byte[] buffer = new byte[10];
        SECURE_RANDOM.nextBytes(buffer);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(buffer);
    }
}

