/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.formatter;

import com.cosium.code.format.formatter.CodeFormatter;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class JavaFormatter
implements CodeFormatter {
    private static final String JAVA_EXTENSION = ".java";
    private final Supplier<Log> log;

    public JavaFormatter(Supplier<Log> log) {
        this.log = log;
    }

    private boolean isJavaFile(Path file) {
        return file.toString().endsWith(JAVA_EXTENSION);
    }

    @Override
    public void format(Path file) {
        String formattedContent;
        Throwable throwable;
        if (!this.isJavaFile(file)) {
            this.log.get().debug((CharSequence)(file + " is not a java file"));
            return;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.log.get().debug((CharSequence)(file + " doesn't exist"));
            return;
        }
        this.log.get().info((CharSequence)("Formatting '" + file + "'"));
        try {
            throwable = null;
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                formattedContent = new Formatter().formatSourceAndFixImports(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FormatterException | IOException e) {
            throw new RuntimeException(e);
        }
        try {
            throwable = null;
            try (OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.TRUNCATE_EXISTING);){
                IOUtils.write((String)formattedContent, (OutputStream)outputStream, (String)"UTF-8");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.log.get().info((CharSequence)("Formatted '" + file + "'"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate(Path file) {
        if (!this.isJavaFile(file)) {
            this.log.get().debug((CharSequence)(file + " is not a java file"));
            return true;
        }
        this.log.get().info((CharSequence)("Validating '" + file + "'"));
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            String unformatterContent = IOUtils.toString((InputStream)inputStream);
            String formattedContent = new Formatter().formatSourceAndFixImports(unformatterContent);
            boolean bl = unformatterContent.equals(formattedContent);
            return bl;
        }
        catch (FormatterException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

