/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.protocol.EngineIOVersion;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class PacketEncoder {
    private static final byte[] BINARY_HEADER = "b4".getBytes(CharsetUtil.UTF_8);
    private static final byte[] B64_DELIMITER = new byte[]{58};
    private static final byte[] JSONP_HEAD = "___eio[".getBytes(CharsetUtil.UTF_8);
    private static final byte[] JSONP_START = "]('".getBytes(CharsetUtil.UTF_8);
    private static final byte[] JSONP_END = "');".getBytes(CharsetUtil.UTF_8);
    private final JsonSupport jsonSupport;
    private final Configuration configuration;
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public PacketEncoder(Configuration configuration, JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
        this.configuration = configuration;
    }

    public JsonSupport getJsonSupport() {
        return this.jsonSupport;
    }

    public ByteBuf allocateBuffer(ByteBufAllocator allocator) {
        if (this.configuration.isPreferDirectBuffer()) {
            return allocator.ioBuffer();
        }
        return allocator.heapBuffer();
    }

    public void encodeJsonP(Integer jsonpIndex, Queue<Packet> packets, ByteBuf out, ByteBufAllocator allocator, int limit) throws IOException {
        Packet packet;
        boolean jsonpMode = jsonpIndex != null;
        ByteBuf buf = this.allocateBuffer(allocator);
        int i = 0;
        while ((packet = packets.poll()) != null && i != limit) {
            ByteBuf packetBuf = this.allocateBuffer(allocator);
            this.encodePacket(packet, packetBuf, allocator, true);
            int packetSize = packetBuf.writerIndex();
            buf.writeBytes(PacketEncoder.toChars(packetSize));
            buf.writeBytes(B64_DELIMITER);
            buf.writeBytes(packetBuf);
            packetBuf.release();
            ++i;
            for (ByteBuf attachment : packet.getAttachments()) {
                ByteBuf encodedBuf = Base64.encode((ByteBuf)attachment, (Base64Dialect)Base64Dialect.URL_SAFE);
                buf.writeBytes(PacketEncoder.toChars(encodedBuf.readableBytes() + 2));
                buf.writeBytes(B64_DELIMITER);
                buf.writeBytes(BINARY_HEADER);
                buf.writeBytes(encodedBuf);
            }
        }
        if (jsonpMode) {
            out.writeBytes(JSONP_HEAD);
            out.writeBytes(PacketEncoder.toChars(jsonpIndex.intValue()));
            out.writeBytes(JSONP_START);
        }
        this.processUtf8(buf, out, jsonpMode);
        buf.release();
        if (jsonpMode) {
            out.writeBytes(JSONP_END);
        }
    }

    private void processUtf8(ByteBuf in, ByteBuf out, boolean jsonpMode) {
        while (in.isReadable()) {
            short value = (short)(in.readByte() & 0xFF);
            if (value >>> 7 == 0) {
                if (jsonpMode && (value == 92 || value == 39)) {
                    out.writeByte(92);
                }
                out.writeByte((int)value);
                continue;
            }
            out.writeByte(value >>> 6 | 0xC0);
            out.writeByte(value & 0x3F | 0x80);
        }
    }

    public void encodePackets(Queue<Packet> packets, ByteBuf buffer, ByteBufAllocator allocator, int limit) throws IOException {
        Packet packet;
        int i = 0;
        while ((packet = packets.poll()) != null && i != limit) {
            this.encodePacket(packet, buffer, allocator, false);
            ++i;
            for (ByteBuf attachment : packet.getAttachments()) {
                buffer.writeByte(1);
                buffer.writeBytes(PacketEncoder.longToBytes(attachment.readableBytes() + 1));
                buffer.writeByte(255);
                buffer.writeByte(4);
                buffer.writeBytes(attachment);
            }
        }
    }

    private byte toChar(int number) {
        return (byte)(number ^ 0x30);
    }

    static int stringSize(long x) {
        int i = 0;
        while (x > (long)sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(long i, int index, byte[] buf) {
        long r;
        long q;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536L) {
            q = i / 100L;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[(int)r];
            buf[--charPos] = (byte)DigitTens[(int)r];
        }
        do {
            q = i * 52429L >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[(int)r];
        } while ((i = q) != 0L);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static byte[] toChars(long i) {
        int size = i < 0L ? PacketEncoder.stringSize(-i) + 1 : PacketEncoder.stringSize(i);
        byte[] buf = new byte[size];
        PacketEncoder.getChars(i, size, buf);
        return buf;
    }

    public static byte[] longToBytes(long number) {
        int length = (int)(Math.log10(number) + 1.0);
        byte[] res = new byte[length];
        int i = length;
        while (number > 0L) {
            res[--i] = (byte)(number % 10L);
            number /= 10L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encodePacket(Packet packet, ByteBuf buffer, ByteBufAllocator allocator, boolean binary) throws IOException {
        ByteBuf buf = buffer;
        if (!binary) {
            buf = this.allocateBuffer(allocator);
        }
        byte type = this.toChar(packet.getType().getValue());
        buf.writeByte((int)type);
        try {
            switch (packet.getType()) {
                case PONG: {
                    buf.writeBytes(packet.getData().toString().getBytes(CharsetUtil.UTF_8));
                    return;
                }
                case OPEN: {
                    ByteBufOutputStream out = new ByteBufOutputStream(buf);
                    this.jsonSupport.writeValue(out, packet.getData());
                    return;
                }
                case MESSAGE: {
                    byte[] ackId;
                    ByteBuf encBuf = null;
                    if (packet.getSubType() == PacketType.ERROR) {
                        encBuf = this.allocateBuffer(allocator);
                        ByteBufOutputStream out = new ByteBufOutputStream(encBuf);
                        this.jsonSupport.writeValue(out, packet.getData());
                    }
                    if (packet.getSubType() == PacketType.EVENT || packet.getSubType() == PacketType.ACK) {
                        ArrayList<String> values = new ArrayList<String>();
                        if (packet.getSubType() == PacketType.EVENT) {
                            values.add(packet.getName());
                        }
                        encBuf = this.allocateBuffer(allocator);
                        List args = (List)packet.getData();
                        values.addAll(args);
                        ByteBufOutputStream out = new ByteBufOutputStream(encBuf);
                        this.jsonSupport.writeValue(out, values);
                        if (!this.jsonSupport.getArrays().isEmpty()) {
                            packet.initAttachments(this.jsonSupport.getArrays().size());
                            for (byte[] array : this.jsonSupport.getArrays()) {
                                packet.addAttachment(Unpooled.wrappedBuffer((byte[])array));
                            }
                            packet.setSubType(packet.getSubType() == PacketType.ACK ? PacketType.BINARY_ACK : PacketType.BINARY_EVENT);
                        }
                    }
                    byte subType = this.toChar(packet.getSubType().getValue());
                    buf.writeByte((int)subType);
                    if (packet.hasAttachments()) {
                        ackId = PacketEncoder.toChars(packet.getAttachments().size());
                        buf.writeBytes(ackId);
                        buf.writeByte(45);
                    }
                    if (packet.getSubType() == PacketType.CONNECT) {
                        if (!packet.getNsp().isEmpty()) {
                            buf.writeBytes(packet.getNsp().getBytes(CharsetUtil.UTF_8));
                        }
                        if (EngineIOVersion.V4.equals((Object)packet.getEngineIOVersion()) && packet.getData() != null) {
                            ByteBufOutputStream out = new ByteBufOutputStream(buf);
                            this.jsonSupport.writeValue(out, packet.getData());
                        }
                    } else if (!packet.getNsp().isEmpty()) {
                        buf.writeBytes(packet.getNsp().getBytes(CharsetUtil.UTF_8));
                        buf.writeByte(44);
                    }
                    if (packet.getAckId() != null) {
                        ackId = PacketEncoder.toChars(packet.getAckId());
                        buf.writeBytes(ackId);
                    }
                    if (encBuf == null) return;
                    buf.writeBytes(encBuf);
                    encBuf.release();
                    return;
                }
            }
            return;
        }
        finally {
            if (!binary) {
                if (!EngineIOVersion.V4.equals((Object)packet.getEngineIOVersion())) {
                    buffer.writeByte(0);
                    int length = buf.writerIndex();
                    buffer.writeBytes(PacketEncoder.longToBytes(length));
                    buffer.writeByte(255);
                }
                buffer.writeBytes(buf);
                buf.release();
            }
        }
    }

    public static int find(ByteBuf buffer, ByteBuf searchValue) {
        for (int i = buffer.readerIndex(); i < buffer.readerIndex() + buffer.readableBytes(); ++i) {
            if (!PacketEncoder.isValueFound(buffer, i, searchValue)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isValueFound(ByteBuf buffer, int index, ByteBuf search) {
        for (int i = 0; i < search.readableBytes(); ++i) {
            if (buffer.getByte(index + i) == search.getByte(i)) continue;
            return false;
        }
        return true;
    }
}

