/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import io.netty.buffer.ByteBuf;

public class UTF8CharsScanner {
    static final int[] sInputCodes;
    static final int[] sInputCodesUtf8;

    private int getCharTailIndex(ByteBuf inputBuffer, int i) {
        int c = inputBuffer.getByte(i) & 0xFF;
        switch (sInputCodesUtf8[c]) {
            case 2: {
                i += 2;
                break;
            }
            case 3: {
                i += 3;
                break;
            }
            case 4: {
                i += 4;
                break;
            }
            default: {
                ++i;
            }
        }
        return i;
    }

    public int getActualLength(ByteBuf inputBuffer, int length) {
        int len = 0;
        int start = inputBuffer.readerIndex();
        int i = inputBuffer.readerIndex();
        while (i < inputBuffer.readableBytes() + inputBuffer.readerIndex()) {
            i = this.getCharTailIndex(inputBuffer, i);
            if (length != ++len) continue;
            return i - start;
        }
        throw new IllegalStateException();
    }

    static {
        int[] table = new int[256];
        for (int i = 0; i < 32; ++i) {
            table[i] = -1;
        }
        table[34] = 1;
        table[92] = 1;
        sInputCodes = table;
        table = new int[sInputCodes.length];
        System.arraycopy(sInputCodes, 0, table, 0, sInputCodes.length);
        for (int c = 128; c < 256; ++c) {
            int code = (c & 0xE0) == 192 ? 2 : ((c & 0xF0) == 224 ? 3 : ((c & 0xF8) == 240 ? 4 : -1));
            table[c] = code;
        }
        sInputCodesUtf8 = table;
    }
}

