/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceClient
implements SocketIOClient {
    private static final Logger log = LoggerFactory.getLogger(NamespaceClient.class);
    private final AtomicBoolean disconnected = new AtomicBoolean();
    private final ClientHead baseClient;
    private final Namespace namespace;

    public NamespaceClient(ClientHead baseClient, Namespace namespace) {
        this.baseClient = baseClient;
        this.namespace = namespace;
        namespace.addClient(this);
    }

    public ClientHead getBaseClient() {
        return this.baseClient;
    }

    @Override
    public Transport getTransport() {
        return this.baseClient.getCurrentTransport();
    }

    @Override
    public boolean isChannelOpen() {
        return this.baseClient.isChannelOpen();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void sendEvent(String name, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        this.send(packet);
    }

    @Override
    public void sendEvent(String name, AckCallback<?> ackCallback, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        this.send(packet, ackCallback);
    }

    private boolean isConnected() {
        return !this.disconnected.get() && this.baseClient.isConnected();
    }

    @Override
    public void send(Packet packet, AckCallback<?> ackCallback) {
        if (!this.isConnected()) {
            ackCallback.onTimeout();
            return;
        }
        long index = this.baseClient.getAckManager().registerAck(this.getSessionId(), ackCallback);
        packet.setAckId(index);
        this.send(packet);
    }

    @Override
    public void send(Packet packet) {
        if (!this.isConnected()) {
            return;
        }
        this.baseClient.send(packet.withNsp(this.namespace.getName()));
    }

    public void onDisconnect() {
        this.disconnected.set(true);
        this.baseClient.removeNamespaceClient(this);
        this.namespace.onDisconnect(this);
        log.debug("Client {} for namespace {} has been disconnected", (Object)this.baseClient.getSessionId(), (Object)this.getNamespace().getName());
    }

    @Override
    public void disconnect() {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setSubType(PacketType.DISCONNECT);
        this.send(packet);
    }

    @Override
    public UUID getSessionId() {
        return this.baseClient.getSessionId();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.baseClient.getRemoteAddress();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        result = 31 * result + (this.getNamespace().getName() == null ? 0 : this.getNamespace().getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceClient other = (NamespaceClient)obj;
        if (this.getSessionId() == null ? other.getSessionId() != null : !this.getSessionId().equals(other.getSessionId())) {
            return false;
        }
        return !(this.getNamespace().getName() == null ? other.getNamespace().getName() != null : !this.getNamespace().getName().equals(other.getNamespace().getName()));
    }

    @Override
    public void joinRoom(String room) {
        this.namespace.joinRoom(room, this.getSessionId());
    }

    @Override
    public void leaveRoom(String room) {
        this.namespace.leaveRoom(room, this.getSessionId());
    }

    @Override
    public void set(String key, Object val) {
        this.baseClient.getStore().set(key, val);
    }

    @Override
    public <T> T get(String key) {
        return this.baseClient.getStore().get(key);
    }

    @Override
    public boolean has(String key) {
        return this.baseClient.getStore().has(key);
    }

    @Override
    public void del(String key) {
        this.baseClient.getStore().del(key);
    }

    @Override
    public Set<String> getAllRooms() {
        return this.namespace.getRooms(this);
    }

    @Override
    public HandshakeData getHandshakeData() {
        return this.baseClient.getHandshakeData();
    }
}

