/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.parser;

import com.corundumstudio.socketio.parser.ErrorAdvice;
import com.corundumstudio.socketio.parser.ErrorReason;
import com.corundumstudio.socketio.parser.PacketType;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public class Packet
implements Serializable {
    private static final long serialVersionUID = 4560159536486711426L;
    public static final char DELIMITER = '\ufffd';
    public static final byte[] DELIMITER_BYTES = new String(new char[]{'\ufffd'}).getBytes(Charset.forName("UTF-8"));
    public static final byte SEPARATOR = 58;
    public static final String ACK_DATA = "data";
    public static final Packet NULL_INSTANCE = new Packet(null);
    private PacketType type;
    private List<Object> args = Collections.emptyList();
    private String qs;
    private Object ack;
    private Long ackId;
    private String name;
    private Long id;
    private String endpoint;
    private Object data;
    private ErrorReason reason;
    private ErrorAdvice advice;

    protected Packet() {
    }

    public Packet(PacketType type) {
        this.type = type;
    }

    public PacketType getType() {
        return this.type;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAck(Object ack) {
        this.ack = ack;
    }

    public Object getAck() {
        return this.ack;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }

    public String getQs() {
        return this.qs;
    }

    public void setQs(String qs) {
        this.qs = qs;
    }

    public Long getAckId() {
        return this.ackId;
    }

    public void setAckId(Long ackId) {
        this.ackId = ackId;
    }

    public ErrorReason getReason() {
        return this.reason;
    }

    public void setReason(ErrorReason reason) {
        this.reason = reason;
    }

    public ErrorAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(ErrorAdvice advice) {
        this.advice = advice;
    }

    private boolean isMessageAck() {
        return ACK_DATA.equals(this.getAck()) && this.getType().equals((Object)PacketType.MESSAGE);
    }

    private boolean isJsonAck() {
        return (Boolean.TRUE.equals(this.getAck()) || ACK_DATA.equals(this.getAck())) && this.getType().equals((Object)PacketType.JSON);
    }

    private boolean isEventAck() {
        return ACK_DATA.equals(this.getAck()) && this.getType().equals((Object)PacketType.EVENT);
    }

    public boolean isAckRequested() {
        return this.getId() != null && (this.isEventAck() || this.isJsonAck() || this.isMessageAck());
    }

    public String toString() {
        return "Packet [type=" + (Object)((Object)this.type) + ", args=" + this.args + ", id=" + this.id + "]";
    }
}

