/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.parser;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.parser.AckArgs;
import com.corundumstudio.socketio.parser.DecoderException;
import com.corundumstudio.socketio.parser.ErrorAdvice;
import com.corundumstudio.socketio.parser.ErrorReason;
import com.corundumstudio.socketio.parser.Event;
import com.corundumstudio.socketio.parser.JsonObject;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.parser.UTF8CharsScanner;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;

public class Decoder {
    private final UTF8CharsScanner charsScanner = new UTF8CharsScanner();
    private final JsonSupport jsonSupport;
    private final AckManager ackManager;

    public Decoder(JsonSupport jsonSupport, AckManager ackManager) {
        this.jsonSupport = jsonSupport;
        this.ackManager = ackManager;
    }

    private long parseLong(ByteBuf chars) {
        return this.parseLong(chars, chars.readerIndex() + chars.readableBytes());
    }

    private long parseLong(ByteBuf chars, int length) {
        long result = 0L;
        for (int i = chars.readerIndex(); i < length; ++i) {
            int digit = chars.getByte(i) & 0xF;
            for (int j = 0; j < length - 1 - i; ++j) {
                digit *= 10;
            }
            result += (long)digit;
        }
        return result;
    }

    private Packet decodePacket(ByteBuf buffer, UUID uuid) throws IOException {
        if (buffer.readableBytes() < 3) {
            throw new DecoderException("Can't parse " + buffer.toString(CharsetUtil.UTF_8));
        }
        PacketType type = this.getType(buffer);
        int readerIndex = buffer.readerIndex() + 1;
        boolean hasData = false;
        StringBuilder messageId = null;
        ++readerIndex;
        while (readerIndex < buffer.readableBytes()) {
            byte msg;
            if (messageId == null) {
                messageId = new StringBuilder(4);
            }
            if ((msg = buffer.getByte(readerIndex)) == 58) break;
            if (msg != 43) {
                messageId.append((char)msg);
            } else {
                hasData = true;
            }
            ++readerIndex;
        }
        Long id = null;
        if (messageId != null && messageId.length() > 0) {
            id = Long.valueOf(messageId.toString());
        }
        StringBuilder endpointBuffer = null;
        ++readerIndex;
        while (readerIndex < buffer.readableBytes()) {
            byte msg;
            if (endpointBuffer == null) {
                endpointBuffer = new StringBuilder();
            }
            if ((msg = buffer.getByte(readerIndex)) == 58) break;
            endpointBuffer.append((char)msg);
            ++readerIndex;
        }
        String endpoint = "";
        if (endpointBuffer != null && endpointBuffer.length() > 0) {
            endpoint = endpointBuffer.toString();
        }
        if (buffer.readableBytes() == readerIndex) {
            buffer.readerIndex(buffer.readableBytes());
        } else {
            buffer.readerIndex(++readerIndex);
        }
        Packet packet = new Packet(type);
        packet.setEndpoint(endpoint);
        if (id != null) {
            packet.setId(id);
            if (hasData) {
                packet.setAck("data");
            } else {
                packet.setAck(true);
            }
        }
        switch (type) {
            case ERROR: {
                String[] pieces;
                if (!buffer.isReadable() || (pieces = buffer.toString(CharsetUtil.UTF_8).split("\\+")).length <= 0 || pieces[0].trim().length() <= 0) break;
                ErrorReason reason = ErrorReason.valueOf(Integer.valueOf(pieces[0]));
                packet.setReason(reason);
                if (pieces.length <= 1) break;
                ErrorAdvice advice = ErrorAdvice.valueOf(Integer.valueOf(pieces[1]));
                packet.setAdvice(advice);
                break;
            }
            case MESSAGE: {
                if (buffer.isReadable()) {
                    packet.setData(buffer.toString(CharsetUtil.UTF_8));
                    break;
                }
                packet.setData("");
                break;
            }
            case EVENT: {
                ByteBufInputStream in = new ByteBufInputStream(buffer);
                Event event = this.jsonSupport.readValue(in, Event.class);
                packet.setName(event.getName());
                if (event.getArgs() == null) break;
                packet.setArgs(event.getArgs());
                break;
            }
            case JSON: {
                ByteBufInputStream in = new ByteBufInputStream(buffer);
                JsonObject obj = this.jsonSupport.readValue(in, JsonObject.class);
                if (obj != null) {
                    packet.setData(obj.getObject());
                    break;
                }
                in.reset();
                Object object = this.jsonSupport.readValue(in, Object.class);
                packet.setData(object);
                break;
            }
            case CONNECT: {
                if (!buffer.isReadable()) break;
                packet.setQs(buffer.toString(CharsetUtil.UTF_8));
                break;
            }
            case ACK: {
                if (!buffer.isReadable()) break;
                boolean validFormat = true;
                int plusIndex = -1;
                for (int i = buffer.readerIndex(); i < buffer.readerIndex() + buffer.readableBytes(); ++i) {
                    byte dataChar = buffer.getByte(i);
                    if (Character.isDigit(dataChar)) continue;
                    if (dataChar == 43) {
                        plusIndex = i;
                        break;
                    }
                    validFormat = false;
                    break;
                }
                if (!validFormat) break;
                if (plusIndex == -1) {
                    packet.setAckId(this.parseLong(buffer));
                    break;
                }
                packet.setAckId(this.parseLong(buffer, plusIndex));
                buffer.readerIndex(plusIndex + 1);
                ByteBufInputStream in = new ByteBufInputStream(buffer);
                AckCallback<?> callback = this.ackManager.getCallback(uuid, packet.getAckId());
                AckArgs args = this.jsonSupport.readAckArgs(in, callback);
                packet.setArgs(args.getArgs());
                break;
            }
        }
        buffer.readerIndex(buffer.readerIndex() + buffer.readableBytes());
        return packet;
    }

    private PacketType getType(ByteBuf buffer) {
        int typeId = buffer.getByte(buffer.readerIndex()) & 0xF;
        if (typeId >= PacketType.VALUES.length || buffer.getByte(buffer.readerIndex() + 1) != 58) {
            throw new DecoderException("Can't parse " + buffer.toString(CharsetUtil.UTF_8));
        }
        return PacketType.valueOf(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet decodePacket(String string, UUID uuid) throws IOException {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)string, (Charset)CharsetUtil.UTF_8);
        try {
            Packet packet;
            Packet packet2 = packet = this.decodePacket(buf, uuid);
            return packet2;
        }
        finally {
            buf.release();
        }
    }

    public Packet decodePackets(ByteBuf buffer, UUID uuid) throws IOException {
        if (this.isCurrentDelimiter(buffer, buffer.readerIndex())) {
            buffer.readerIndex(buffer.readerIndex() + Packet.DELIMITER_BYTES.length);
            Integer len = this.extractLength(buffer);
            int startIndex = buffer.readerIndex();
            ByteBuf frame = buffer.slice(startIndex, len.intValue());
            Packet packet = this.decodePacket(frame, uuid);
            buffer.readerIndex(startIndex + len);
            return packet;
        }
        Packet packet = this.decodePacket(buffer, uuid);
        return packet;
    }

    private Integer extractLength(ByteBuf buffer) {
        int len = (int)this.parseLengthHeader(buffer);
        if (buffer.capacity() > buffer.readerIndex() + len && !this.isCurrentDelimiter(buffer, buffer.readerIndex() + len)) {
            int index = this.charsScanner.findTailIndex(buffer, buffer.readerIndex(), buffer.capacity(), len);
            len = index - buffer.readerIndex();
        }
        return len;
    }

    private long parseLengthHeader(ByteBuf buffer) {
        int delimiterIndex = this.delimiterIndexOf(buffer, buffer.readerIndex(), buffer.readableBytes());
        if (delimiterIndex == -1) {
            throw new DecoderException("Can't find tail delimiter");
        }
        long len = this.parseLong(buffer, delimiterIndex);
        buffer.readerIndex(delimiterIndex + Packet.DELIMITER_BYTES.length);
        return len;
    }

    private int delimiterIndexOf(ByteBuf buffer, int startIndex, int length) {
        ByteBuf buf = buffer.slice(startIndex, length);
        for (int i = 0; i < buf.readableBytes(); ++i) {
            if (!this.isCurrentDelimiter(buf, i)) continue;
            return startIndex + i;
        }
        return -1;
    }

    private boolean isCurrentDelimiter(ByteBuf buffer, int index) {
        for (int i = 0; i < Packet.DELIMITER_BYTES.length; ++i) {
            if (buffer.getByte(index + i) == Packet.DELIMITER_BYTES[i]) continue;
            return false;
        }
        return true;
    }
}

