/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.messages.AuthorizeMessage;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.store.pubsub.ConnectMessage;
import com.corundumstudio.socketio.transport.MainBaseClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class AuthorizeHandler
extends ChannelInboundHandlerAdapter
implements Disconnectable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CancelableScheduler disconnectScheduler;
    private final Map<UUID, HandshakeData> authorizedSessionIds;
    private final String connectPath;
    private final Configuration configuration;
    private final NamespacesHub namespacesHub;

    public AuthorizeHandler(String connectPath, CancelableScheduler scheduler, Configuration configuration, NamespacesHub namespacesHub) {
        this.connectPath = connectPath;
        this.configuration = configuration;
        this.disconnectScheduler = scheduler;
        this.namespacesHub = namespacesHub;
        this.authorizedSessionIds = configuration.getStoreFactory().createMap("authorizedSessionIds");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            Channel channel = ctx.channel();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.getUri());
            if (!this.configuration.isAllowCustomRequests() && !queryDecoder.path().startsWith(this.connectPath)) {
                DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                ChannelFuture f = channel.write((Object)res);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                req.release();
                this.log.warn("Blocked wrong request! url: {}, ip: {}", (Object)queryDecoder.path(), (Object)channel.remoteAddress());
                return;
            }
            if (queryDecoder.path().equals(this.connectPath)) {
                String origin = req.headers().get("Origin");
                this.authorize(channel, origin, queryDecoder.parameters(), req);
                req.release();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void authorize(Channel channel, String origin, Map<String, List<String>> params, FullHttpRequest req) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(req.headers().names().size());
        for (String name : req.headers().names()) {
            List values = req.headers().getAll(name);
            headers.put(name, values);
        }
        HandshakeData data = new HandshakeData(headers, params, (InetSocketAddress)channel.remoteAddress(), req.getUri(), origin != null && !origin.equalsIgnoreCase("null"));
        boolean result = false;
        try {
            result = this.configuration.getAuthorizationListener().isAuthorized(data);
        }
        catch (Exception e) {
            this.log.error("Authorization error", (Throwable)e);
        }
        if (result) {
            UUID sessionId = UUID.randomUUID();
            this.scheduleDisconnect(channel, sessionId);
            String msg = this.createHandshake(sessionId);
            List<String> jsonpParams = params.get("jsonp");
            String jsonpParam = null;
            if (jsonpParams != null) {
                jsonpParam = jsonpParams.get(0);
            }
            channel.writeAndFlush((Object)new AuthorizeMessage(msg, jsonpParam, origin, sessionId));
            this.authorizedSessionIds.put(sessionId, data);
            this.log.debug("Handshake authorized for sessionId: {}", (Object)sessionId);
        } else {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
            ChannelFuture f = channel.writeAndFlush((Object)res);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.log.debug("Handshake unauthorized");
        }
    }

    private String createHandshake(UUID sessionId) {
        String heartbeatTimeoutVal = String.valueOf(this.configuration.getHeartbeatTimeout());
        if (!this.configuration.isHeartbeatsEnabled()) {
            heartbeatTimeoutVal = "";
        }
        String msg = sessionId + ":" + heartbeatTimeoutVal + ":" + this.configuration.getCloseTimeout() + ":" + this.configuration.getTransports();
        return msg;
    }

    private void scheduleDisconnect(Channel channel, final UUID sessionId) {
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                SchedulerKey key = new SchedulerKey(SchedulerKey.Type.AUTHORIZE, sessionId);
                AuthorizeHandler.this.disconnectScheduler.schedule(key, new Runnable(){

                    @Override
                    public void run() {
                        AuthorizeHandler.this.authorizedSessionIds.remove(sessionId);
                        AuthorizeHandler.this.log.debug("Authorized sessionId: {} removed due to connection timeout", (Object)sessionId);
                    }
                }, AuthorizeHandler.this.configuration.getCloseTimeout(), TimeUnit.SECONDS);
            }
        });
    }

    public HandshakeData getHandshakeData(UUID sessionId) {
        return this.authorizedSessionIds.get(sessionId);
    }

    public void connect(UUID sessionId) {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.AUTHORIZE, sessionId);
        this.disconnectScheduler.cancel(key);
    }

    public void connect(MainBaseClient client) {
        this.connect(client.getSessionId());
        this.configuration.getStoreFactory().pubSubStore().publish("connect", new ConnectMessage(client.getSessionId()));
        client.send(new Packet(PacketType.CONNECT));
        Namespace ns = this.namespacesHub.get("");
        SocketIOClient nsClient = client.addChildClient(ns);
        this.namespacesHub.get(ns.getName()).onConnect(nsClient);
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.authorizedSessionIds.remove(client.getSessionId());
    }
}

