/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.AuthorizationListener;
import com.corundumstudio.socketio.JsonSupportWrapper;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.handler.SuccessAuthorizationListener;
import com.corundumstudio.socketio.listener.DefaultExceptionListener;
import com.corundumstudio.socketio.listener.ExceptionListener;
import com.corundumstudio.socketio.parser.JacksonJsonSupport;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.store.MemoryStoreFactory;
import com.corundumstudio.socketio.store.StoreFactory;
import java.io.InputStream;

public class Configuration {
    private ExceptionListener exceptionListener = new DefaultExceptionListener();
    private String jsonTypeFieldName = "@class";
    private String context = "/socket.io";
    private String transports = this.join(new Transport[]{Transport.WEBSOCKET, Transport.FLASHSOCKET, Transport.XHRPOLLING});
    private int bossThreads = 0;
    private int workerThreads = 0;
    private boolean allowCustomRequests = false;
    private int pollingDuration = 20;
    private int heartbeatTimeout = 60;
    private int heartbeatInterval = 25;
    private int closeTimeout = 60;
    private int maxHttpContentLength = 65536;
    private String packagePrefix;
    private String hostname;
    private int port = -1;
    private InputStream keyStore;
    private String keyStorePassword;
    private boolean preferDirectBuffer = true;
    private SocketConfig socketConfig = new SocketConfig();
    private StoreFactory storeFactory = new MemoryStoreFactory();
    private JsonSupport jsonSupport = new JacksonJsonSupport(this);
    private AuthorizationListener authorizationListener = new SuccessAuthorizationListener();
    private boolean autoAck = true;

    public Configuration() {
    }

    Configuration(Configuration conf) {
        this.setBossThreads(conf.getBossThreads());
        this.setWorkerThreads(conf.getWorkerThreads());
        this.setCloseTimeout(conf.getCloseTimeout());
        this.setHeartbeatInterval(conf.getHeartbeatInterval());
        this.setHeartbeatTimeout(conf.getHeartbeatTimeout());
        this.setHostname(conf.getHostname());
        this.setPort(conf.getPort());
        this.setJsonSupport(new JsonSupportWrapper(conf.getJsonSupport()));
        this.setJsonTypeFieldName(conf.getJsonTypeFieldName());
        this.setContext(conf.getContext());
        this.setAllowCustomRequests(conf.isAllowCustomRequests());
        this.setPollingDuration(conf.getPollingDuration());
        this.setKeyStorePassword(conf.getKeyStorePassword());
        this.setKeyStore(conf.getKeyStore());
        this.setTransports(conf.getTransports());
        this.setMaxHttpContentLength(conf.getMaxHttpContentLength());
        this.setPackagePrefix(conf.getPackagePrefix());
        this.setPreferDirectBuffer(conf.isPreferDirectBuffer());
        this.setStoreFactory(conf.getStoreFactory());
        this.setAuthorizationListener(conf.getAuthorizationListener());
        this.setExceptionListener(conf.getExceptionListener());
        this.setSocketConfig(conf.getSocketConfig());
        this.setAutoAck(conf.isAutoAck());
    }

    private String join(Transport[] transports) {
        StringBuilder result = new StringBuilder();
        for (Transport transport : transports) {
            result.append(transport.getValue());
            result.append(",");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public String getJsonTypeFieldName() {
        return this.jsonTypeFieldName;
    }

    public void setJsonTypeFieldName(String jsonTypeFieldName) {
        this.jsonTypeFieldName = jsonTypeFieldName;
    }

    public JsonSupport getJsonSupport() {
        return this.jsonSupport;
    }

    public void setJsonSupport(JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBossThreads() {
        return this.bossThreads;
    }

    public void setBossThreads(int bossThreads) {
        this.bossThreads = bossThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setHeartbeatInterval(int heartbeatIntervalSecs) {
        this.heartbeatInterval = heartbeatIntervalSecs;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatTimeout(int heartbeatTimeoutSecs) {
        this.heartbeatTimeout = heartbeatTimeoutSecs;
    }

    public int getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public boolean isHeartbeatsEnabled() {
        return this.heartbeatTimeout > 0;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isAllowCustomRequests() {
        return this.allowCustomRequests;
    }

    public void setAllowCustomRequests(boolean allowCustomRequests) {
        this.allowCustomRequests = allowCustomRequests;
    }

    public int getPollingDuration() {
        return this.pollingDuration;
    }

    public void setPollingDuration(int pollingDuration) {
        this.pollingDuration = pollingDuration;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStore(InputStream keyStore) {
        this.keyStore = keyStore;
    }

    public InputStream getKeyStore() {
        return this.keyStore;
    }

    public void setMaxHttpContentLength(int value) {
        this.maxHttpContentLength = value;
    }

    public int getMaxHttpContentLength() {
        return this.maxHttpContentLength;
    }

    public void setTransports(Transport ... transports) {
        if (transports.length == 0) {
            throw new IllegalArgumentException("Transports list can't be empty");
        }
        this.transports = this.join(transports);
    }

    private void setTransports(String transports) {
        this.transports = transports;
    }

    public String getTransports() {
        return this.transports;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPreferDirectBuffer(boolean preferDirectBuffer) {
        this.preferDirectBuffer = preferDirectBuffer;
    }

    public boolean isPreferDirectBuffer() {
        return this.preferDirectBuffer;
    }

    public void setStoreFactory(StoreFactory clientStoreFactory) {
        this.storeFactory = clientStoreFactory;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setAuthorizationListener(AuthorizationListener authorizationListener) {
        this.authorizationListener = authorizationListener;
    }

    public AuthorizationListener getAuthorizationListener() {
        return this.authorizationListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public void setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }
}

