/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.messages.XHRSendPacketsMessage;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.MainBaseClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class XHRPollingClient
extends MainBaseClient {
    public static final AttributeKey<Boolean> WRITE_ONCE = AttributeKey.valueOf((String)"writeOnce");
    private final Queue<Packet> packetQueue = new ConcurrentLinkedQueue<Packet>();
    private String origin;

    public XHRPollingClient(AckManager ackManager, DisconnectableHub disconnectable, UUID sessionId, Transport transport, StoreFactory storeFactory) {
        super(sessionId, ackManager, disconnectable, transport, storeFactory);
    }

    public void bindChannel(Channel channel, String origin) {
        this.origin = origin;
        this.setChannel(channel);
        channel.write((Object)new XHRSendPacketsMessage(this.getSessionId(), origin, this.packetQueue));
    }

    public String getOrigin() {
        return this.origin;
    }

    @Override
    public ChannelFuture send(Packet packet) {
        this.packetQueue.add(packet);
        if (this.getChannel().attr(WRITE_ONCE).get() == null) {
            return this.getChannel().write((Object)new XHRSendPacketsMessage(this.getSessionId(), this.origin, this.packetQueue));
        }
        return this.getChannel().newSucceededFuture();
    }
}

