/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.store.RedisPubSubStore;
import com.corundumstudio.socketio.store.RedisStore;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.pubsub.BaseStoreFactory;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.transport.MainBaseClient;
import java.util.UUID;
import redis.clients.jedis.Jedis;

public class RedisStoreFactory
extends BaseStoreFactory {
    private Jedis redisClient = new Jedis("127.0.0.1", 6379);
    private Jedis redisPub = new Jedis("127.0.0.1", 6379);
    private Jedis redisSub = new Jedis("127.0.0.1", 6379);
    private RedisPubSubStore pubSubRedisStore;

    public RedisStoreFactory() {
    }

    public RedisStoreFactory(Jedis redisClient, Jedis redisPub, Jedis redisSub) {
        this.redisClient = redisClient;
        this.redisPub = redisPub;
        this.redisSub = redisSub;
    }

    @Override
    public void init(NamespacesHub namespacesHub, JsonSupport jsonSupport) {
        this.pubSubRedisStore = new RedisPubSubStore(this.redisPub, this.redisSub, this.getNodeId(), jsonSupport);
        this.redisClient.connect();
        this.redisPub.connect();
        this.redisSub.connect();
        super.init(namespacesHub, jsonSupport);
    }

    @Override
    public Store create(UUID sessionId) {
        return new RedisStore(sessionId, this.redisClient);
    }

    @Override
    public PubSubStore getPubSubStore() {
        return this.pubSubRedisStore;
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.redisClient.del(client.getSessionId().toString());
    }

    @Override
    public void shutdown() {
        this.pubSubRedisStore.shutdown();
        this.redisClient.disconnect();
        this.redisPub.disconnect();
        this.redisSub.disconnect();
    }
}

