/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.HazelcastPubSubStore;
import com.corundumstudio.socketio.store.HazelcastStore;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.pubsub.BaseStoreFactory;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import java.util.UUID;

public class HazelcastStoreFactory
extends BaseStoreFactory {
    private final HazelcastInstance hazelcastClient;
    private final HazelcastInstance hazelcastPub;
    private final HazelcastInstance hazelcastSub;

    public HazelcastStoreFactory() {
        this(HazelcastClient.newHazelcastClient());
    }

    public HazelcastStoreFactory(HazelcastInstance instance) {
        this.hazelcastClient = instance;
        this.hazelcastPub = instance;
        this.hazelcastSub = instance;
    }

    public HazelcastStoreFactory(HazelcastInstance hazelcastClient, HazelcastInstance hazelcastPub, HazelcastInstance hazelcastSub) {
        this.hazelcastClient = hazelcastClient;
        this.hazelcastPub = hazelcastPub;
        this.hazelcastSub = hazelcastSub;
    }

    @Override
    public Store create(UUID sessionId) {
        return new HazelcastStore(sessionId, this.hazelcastClient);
    }

    @Override
    public void shutdown() {
        this.hazelcastClient.shutdown();
    }

    @Override
    public PubSubStore getPubSubStore() {
        return new HazelcastPubSubStore(this.hazelcastPub, this.hazelcastSub, this.getNodeId());
    }
}

