/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.parser;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.misc.ConcurrentHashSet;
import com.corundumstudio.socketio.parser.AckArgs;
import com.corundumstudio.socketio.parser.Event;
import com.corundumstudio.socketio.parser.JsonObject;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JacksonJsonSupport
implements JsonSupport {
    private final ThreadLocal<Class<?>> currentAckClass = new ThreadLocal();
    private final Configuration configuration;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EventDeserializer eventDeserializer = new EventDeserializer();
    private final JsonObjectDeserializer jsonObjectDeserializer = new JsonObjectDeserializer();
    private final AckArgsDeserializer ackArgsDeserializer = new AckArgsDeserializer();

    public JacksonJsonSupport(Configuration configuration) {
        this(configuration, null);
    }

    public JacksonJsonSupport(Configuration configuration, Module ... modules) {
        this.configuration = configuration;
        if (modules != null && modules.length > 0) {
            this.objectMapper.registerModules(modules);
        }
        this.init(this.objectMapper);
    }

    protected void init(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Event.class, (JsonDeserializer)this.eventDeserializer);
        module.addDeserializer(JsonObject.class, (JsonDeserializer)this.jsonObjectDeserializer);
        module.addDeserializer(AckArgs.class, (JsonDeserializer)this.ackArgsDeserializer);
        objectMapper.registerModule((Module)module);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN, true);
    }

    @Override
    public void addEventMapping(String eventName, Class<?> eventClass) {
        this.eventDeserializer.eventMapping.put(eventName, eventClass);
    }

    @Override
    public void addJsonClass(Class<?> clazz) {
        this.jsonObjectDeserializer.classes.add(clazz);
    }

    @Override
    public void removeEventMapping(String eventName) {
        this.eventDeserializer.eventMapping.remove(eventName);
    }

    @Override
    public <T> T readValue(ByteBufInputStream src, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue((InputStream)src, valueType);
    }

    @Override
    public AckArgs readAckArgs(ByteBufInputStream src, Class<?> argType) throws IOException {
        this.currentAckClass.set(argType);
        return (AckArgs)this.objectMapper.readValue((InputStream)src, AckArgs.class);
    }

    @Override
    public void writeValue(ByteBufOutputStream out, Object value) throws IOException {
        this.objectMapper.writeValue((OutputStream)out, value);
    }

    @Override
    public String writeValueAsString(Object value) throws IOException {
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public <T> T readValue(String src, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue(src, valueType);
    }

    private class EventDeserializer
    extends StdDeserializer<Event> {
        final Map<String, Class<?>> eventMapping;

        protected EventDeserializer() {
            super(Event.class);
            this.eventMapping = new ConcurrentHashMap();
        }

        public Event deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Iterator iterator;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            String eventName = root.get("name").asText();
            if (!this.eventMapping.containsKey(eventName)) {
                return new Event(eventName, Collections.emptyList());
            }
            ArrayList<Object> eventArgs = new ArrayList<Object>();
            Event event = new Event(eventName, eventArgs);
            JsonNode args = root.get("args");
            if (args != null && (iterator = args.elements()).hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                Class<?> eventClass = this.eventMapping.get(eventName);
                Object arg = mapper.treeToValue((TreeNode)node, eventClass);
                eventArgs.add(arg);
                while (iterator.hasNext()) {
                    node = (JsonNode)iterator.next();
                    arg = mapper.treeToValue((TreeNode)node, Object.class);
                    eventArgs.add(arg);
                }
            }
            return event;
        }
    }

    private class AckArgsDeserializer
    extends StdDeserializer<AckArgs> {
        protected AckArgsDeserializer() {
            super(AckArgs.class);
        }

        public AckArgs deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Object> args = new ArrayList<Object>();
            AckArgs result = new AckArgs(args);
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode root = (JsonNode)mapper.readTree(jp);
            Class<Object> clazz = (Class<Object>)JacksonJsonSupport.this.currentAckClass.get();
            for (JsonNode arg : root) {
                if (arg.isTextual() || arg.isBoolean()) {
                    clazz = Object.class;
                }
                if (arg.isNumber()) {
                    Number number;
                    if (clazz.equals(Long.class)) {
                        number = arg.longValue();
                    }
                    if (clazz.equals(BigDecimal.class)) {
                        number = arg.bigIntegerValue();
                    }
                    if (clazz.equals(Double.class)) {
                        number = arg.doubleValue();
                    }
                    if (clazz.equals(Integer.class)) {
                        number = arg.intValue();
                    }
                    if (clazz.equals(Float.class)) {
                        number = Float.valueOf((float)arg.doubleValue());
                    }
                }
                Object val = mapper.treeToValue((TreeNode)arg, clazz);
                args.add(val);
            }
            return result;
        }
    }

    private class JsonObjectDeserializer
    extends StdDeserializer<JsonObject> {
        final Set<Class<?>> classes;

        protected JsonObjectDeserializer() {
            super(JsonObject.class);
            this.classes = new ConcurrentHashSet();
        }

        public JsonObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode rootNode = (JsonNode)mapper.readTree(jp);
            if (!rootNode.isObject()) {
                return null;
            }
            Object val = this.readObject(mapper, rootNode);
            return new JsonObject(val);
        }

        private Object readObject(ObjectMapper mapper, JsonNode rootNode) throws IOException, JsonParseException, JsonMappingException {
            Class clazz = Object.class;
            ObjectNode root = (ObjectNode)rootNode;
            JsonNode node = root.remove(JacksonJsonSupport.this.configuration.getJsonTypeFieldName());
            if (node != null) {
                try {
                    Class<?> supportClazz;
                    String typeName = node.asText();
                    if (JacksonJsonSupport.this.configuration.getPackagePrefix() != null) {
                        typeName = JacksonJsonSupport.this.configuration.getPackagePrefix() + "." + typeName;
                    }
                    if (this.classes.contains(supportClazz = Class.forName(typeName))) {
                        clazz = supportClazz;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            Object val = mapper.treeToValue((TreeNode)root, clazz);
            return val;
        }
    }
}

