/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.namespace;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIONamespace;
import com.corundumstudio.socketio.annotation.ScannerEngine;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.namespace.EventEntry;
import com.corundumstudio.socketio.parser.JsonSupport;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.transport.NamespaceClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class Namespace
implements SocketIONamespace {
    public static final String DEFAULT_NAME = "";
    private final Map<UUID, SocketIOClient> allClients = new ConcurrentHashMap<UUID, SocketIOClient>();
    private final ConcurrentMap<String, EventEntry<?>> eventListeners = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Queue<DataListener<?>>> jsonObjectListeners = new ConcurrentHashMap();
    private final Queue<DataListener<String>> messageListeners = new ConcurrentLinkedQueue<DataListener<String>>();
    private final Queue<ConnectListener> connectListeners = new ConcurrentLinkedQueue<ConnectListener>();
    private final Queue<DisconnectListener> disconnectListeners = new ConcurrentLinkedQueue<DisconnectListener>();
    private final ConcurrentMap<String, Queue<UUID>> roomClients = new ConcurrentHashMap<String, Queue<UUID>>();
    private final String name;
    private final JsonSupport jsonSupport;
    private final StoreFactory storeFactory;

    public Namespace(String name, JsonSupport jsonSupport, StoreFactory storeFactory) {
        this.name = name;
        this.jsonSupport = jsonSupport;
        this.storeFactory = storeFactory;
    }

    public void addClient(SocketIOClient client) {
        this.allClients.put(client.getSessionId(), client);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <T> void addEventListener(String eventName, Class<T> eventClass, DataListener<T> listener) {
        EventEntry<T> oldEntry;
        EventEntry<T> entry = (EventEntry<T>)this.eventListeners.get(eventName);
        if (entry == null && (oldEntry = this.eventListeners.putIfAbsent(eventName, entry = new EventEntry<T>(eventClass))) != null) {
            entry = oldEntry;
        }
        entry.addListener(listener);
        this.jsonSupport.addEventMapping(eventName, eventClass);
    }

    @Override
    public <T> void addJsonObjectListener(Class<T> clazz, DataListener<T> listener) {
        Queue oldQueue;
        Queue<DataListener<Object>> queue = (ConcurrentLinkedQueue<DataListener<T>>)this.jsonObjectListeners.get(clazz);
        if (queue == null && (oldQueue = (Queue)this.jsonObjectListeners.putIfAbsent(clazz, queue = new ConcurrentLinkedQueue<DataListener<T>>())) != null) {
            queue = oldQueue;
        }
        queue.add(listener);
        this.jsonSupport.addJsonClass(clazz);
    }

    public void onEvent(NamespaceClient client, String eventName, Object data, AckRequest ackRequest) {
        EventEntry entry = (EventEntry)this.eventListeners.get(eventName);
        if (entry == null) {
            return;
        }
        Queue listeners = entry.getListeners();
        for (DataListener dataListener : listeners) {
            dataListener.onData(client, data, ackRequest);
        }
    }

    public void onMessage(NamespaceClient client, String data, AckRequest ackRequest) {
        for (DataListener dataListener : this.messageListeners) {
            dataListener.onData(client, data, ackRequest);
        }
    }

    public void onJsonObject(NamespaceClient client, Object data, AckRequest ackRequest) {
        Queue queue = (Queue)this.jsonObjectListeners.get(data.getClass());
        if (queue == null) {
            return;
        }
        for (DataListener dataListener : queue) {
            dataListener.onData(client, data, ackRequest);
        }
    }

    @Override
    public void addDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.add(listener);
    }

    public void onDisconnect(SocketIOClient client) {
        for (DisconnectListener listener : this.disconnectListeners) {
            listener.onDisconnect(client);
        }
        this.allClients.remove(client);
        this.leave(this.getName(), client.getSessionId());
        this.storeFactory.getPubSubStore().publish("leave", new JoinLeaveMessage(client.getSessionId(), this.getName()));
    }

    @Override
    public void addConnectListener(ConnectListener listener) {
        this.connectListeners.add(listener);
    }

    public void onConnect(SocketIOClient client) {
        for (ConnectListener listener : this.connectListeners) {
            listener.onConnect(client);
        }
        this.join(this.getName(), client.getSessionId());
        this.storeFactory.getPubSubStore().publish("join", new JoinLeaveMessage(client.getSessionId(), this.getName()));
    }

    @Override
    public void addMessageListener(DataListener<String> listener) {
        this.messageListeners.add(listener);
    }

    public Queue<DataListener<String>> getMessageListeners() {
        return this.messageListeners;
    }

    @Override
    public BroadcastOperations getBroadcastOperations() {
        return new BroadcastOperations(this.allClients.values(), this.storeFactory);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void addListeners(Object listeners) {
        ScannerEngine engine = new ScannerEngine();
        engine.scan(this, listeners, listeners.getClass());
    }

    @Override
    public void addListeners(Object listeners, Class listenersClass) {
        ScannerEngine engine = new ScannerEngine();
        engine.scan(this, listeners, listenersClass);
    }

    public void joinRoom(String room, UUID sessionId) {
        room = room + this.getName() + "/" + room;
        this.join(room, sessionId);
        this.storeFactory.getPubSubStore().publish("join", new JoinLeaveMessage(sessionId, room));
    }

    public void doDispatch(String room, Packet packet) {
        if (room != null && !room.isEmpty()) {
            room = room + this.getName() + "/" + room;
        }
        this.storeFactory.getPubSubStore().publish("dispatch", new DispatchMessage(room, packet));
    }

    public void dispatch(String room, Packet packet) {
        Iterable<SocketIOClient> clients = this.getRoomClients(room);
        for (SocketIOClient socketIOClient : clients) {
            socketIOClient.send(packet);
        }
    }

    public void join(String room, UUID sessionId) {
        Queue oldClients;
        Queue<UUID> clients = (ConcurrentLinkedQueue<UUID>)this.roomClients.get(room);
        if (clients == null && (oldClients = (Queue)this.roomClients.putIfAbsent(room, clients = new ConcurrentLinkedQueue<UUID>())) != null) {
            clients = oldClients;
        }
        clients.add(sessionId);
        if (clients != this.roomClients.get(room)) {
            this.joinRoom(room, sessionId);
        }
    }

    public void leaveRoom(String room, UUID sessionId) {
        room = room + this.getName() + "/" + room;
        this.leave(room, sessionId);
        this.storeFactory.getPubSubStore().publish("leave", new JoinLeaveMessage(sessionId, room));
    }

    public void leave(String room, UUID sessionId) {
        Queue clients = (Queue)this.roomClients.get(room);
        if (clients == null) {
            return;
        }
        clients.remove(sessionId);
        if (clients.isEmpty()) {
            clients = (Queue)this.roomClients.remove(room);
            for (UUID clientId : clients) {
                this.joinRoom(room, clientId);
            }
        }
    }

    public List<String> getRooms(SocketIOClient client) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.roomClients.entrySet()) {
            if (!((Queue)entry.getValue()).contains(client.getSessionId())) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    public Iterable<SocketIOClient> getRoomClients(String room) {
        Queue sessionIds = (Queue)this.roomClients.get(room);
        if (sessionIds == null) {
            return Collections.emptyList();
        }
        ArrayList<SocketIOClient> result = new ArrayList<SocketIOClient>();
        for (SocketIOClient client : this.allClients.values()) {
            if (!sessionIds.contains(client.getSessionId())) continue;
            result.add(client);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.allClients.isEmpty();
    }
}

