/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.HeartbeatHandler;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.transport.NamespaceClient;
import java.util.Collections;

public class PacketListener {
    private final NamespacesHub namespacesHub;
    private final AckManager ackManager;
    private final HeartbeatHandler heartbeatHandler;

    public PacketListener(HeartbeatHandler heartbeatHandler, AckManager ackManager, NamespacesHub namespacesHub) {
        this.heartbeatHandler = heartbeatHandler;
        this.ackManager = ackManager;
        this.namespacesHub = namespacesHub;
    }

    public void onPacket(Packet packet, NamespaceClient client) {
        AckRequest ackRequest = new AckRequest(packet, client);
        if (packet.isAckRequested()) {
            this.ackManager.initAckIndex(client.getSessionId(), packet.getId());
        }
        switch (packet.getType()) {
            case CONNECT: {
                Namespace namespace = this.namespacesHub.get(packet.getEndpoint());
                namespace.onConnect(client);
                client.send(packet);
                break;
            }
            case ACK: {
                this.ackManager.onAck(client, packet);
                break;
            }
            case EVENT: {
                Object data = null;
                if (packet.getArgs() != null && !packet.getArgs().isEmpty()) {
                    data = packet.getArgs().get(0);
                }
                Namespace namespace = this.namespacesHub.get(packet.getEndpoint());
                namespace.onEvent(client, packet.getName(), data, ackRequest);
                break;
            }
            case HEARTBEAT: {
                this.heartbeatHandler.onHeartbeat(client.getBaseClient());
                break;
            }
            case MESSAGE: {
                Namespace namespace = this.namespacesHub.get(packet.getEndpoint());
                namespace.onMessage(client, packet.getData().toString(), ackRequest);
                break;
            }
            case JSON: {
                Namespace namespace = this.namespacesHub.get(packet.getEndpoint());
                namespace.onJsonObject(client, packet.getData(), ackRequest);
                break;
            }
            case DISCONNECT: {
                client.onDisconnect();
                break;
            }
        }
        ackRequest.sendAckData(Collections.<Object>emptyList());
    }
}

