/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.handler.PacketListener;
import com.corundumstudio.socketio.messages.PacketsMessage;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.Decoder;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.transport.MainBaseClient;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<PacketsMessage> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final PacketListener packetListener;
    private final Decoder decoder;
    private final NamespacesHub namespacesHub;

    public PacketHandler(PacketListener packetListener, Decoder decoder, NamespacesHub namespacesHub) {
        this.packetListener = packetListener;
        this.decoder = decoder;
        this.namespacesHub = namespacesHub;
    }

    protected void channelRead0(ChannelHandlerContext ctx, PacketsMessage message) throws Exception {
        ByteBuf content = message.getContent();
        MainBaseClient client = message.getClient();
        if (this.log.isTraceEnabled()) {
            this.log.trace("In message: {} sessionId: {}", (Object)content.toString(CharsetUtil.UTF_8), (Object)client.getSessionId());
        }
        while (content.isReadable()) {
            try {
                Packet packet = this.decoder.decodePackets(content, client.getSessionId());
                Namespace ns = this.namespacesHub.get(packet.getEndpoint());
                if (ns == null) {
                    this.log.warn("Can't find namespace for endpoint: {} probably it was removed.", (Object)packet.getEndpoint());
                    return;
                }
                NamespaceClient nClient = (NamespaceClient)client.getChildClient(ns);
                this.packetListener.onPacket(packet, nClient);
            }
            catch (Exception ex) {
                String c = content.toString(CharsetUtil.UTF_8);
                this.log.error("Error during data processing. Client sessionId: " + client.getSessionId() + ", data: " + c, (Throwable)ex);
                return;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        this.log.error("Exception occurs", e);
    }
}

