/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.messages.AuthorizeMessage;
import com.corundumstudio.socketio.misc.ConcurrentHashSet;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.transport.MainBaseClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class AuthorizeHandler
extends ChannelInboundHandlerAdapter
implements Disconnectable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CancelableScheduler disconnectScheduler;
    private final Set<UUID> authorizedSessionIds = new ConcurrentHashSet<UUID>();
    private final String connectPath;
    private final Configuration configuration;
    private final NamespacesHub namespacesHub;

    public AuthorizeHandler(String connectPath, CancelableScheduler scheduler, Configuration configuration, NamespacesHub namespacesHub) {
        this.connectPath = connectPath;
        this.configuration = configuration;
        this.disconnectScheduler = scheduler;
        this.namespacesHub = namespacesHub;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            Channel channel = ctx.channel();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.getUri());
            if (!this.configuration.isAllowCustomRequests() && !queryDecoder.path().startsWith(this.connectPath)) {
                DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                ChannelFuture f = channel.write((Object)res);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                req.release();
                this.log.warn("Blocked wrong request! url: {}, ip: {}", (Object)queryDecoder.path(), (Object)channel.remoteAddress());
                return;
            }
            if (queryDecoder.path().equals(this.connectPath)) {
                String origin = req.headers().get("Origin");
                this.authorize(channel, origin, queryDecoder.parameters());
                req.release();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void authorize(Channel channel, String origin, Map<String, List<String>> params) throws IOException {
        UUID sessionId = UUID.randomUUID();
        this.authorizedSessionIds.add(sessionId);
        this.scheduleDisconnect(channel, sessionId);
        String heartbeatTimeoutVal = String.valueOf(this.configuration.getHeartbeatTimeout());
        if (!this.configuration.isHeartbeatsEnabled()) {
            heartbeatTimeoutVal = "";
        }
        String msg = sessionId + ":" + heartbeatTimeoutVal + ":" + this.configuration.getCloseTimeout() + ":" + this.configuration.getTransports();
        List<String> jsonpParams = params.get("jsonp");
        String jsonpParam = null;
        if (jsonpParams != null) {
            jsonpParam = jsonpParams.get(0);
        }
        channel.write((Object)new AuthorizeMessage(msg, jsonpParam, origin, sessionId));
        this.log.debug("New sessionId: {} authorized", (Object)sessionId);
    }

    private void scheduleDisconnect(Channel channel, final UUID sessionId) {
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                SchedulerKey key = new SchedulerKey(SchedulerKey.Type.AUTHORIZE, sessionId);
                AuthorizeHandler.this.disconnectScheduler.schedule(key, new Runnable(){

                    @Override
                    public void run() {
                        AuthorizeHandler.this.authorizedSessionIds.remove(sessionId);
                        AuthorizeHandler.this.log.debug("Authorized sessionId: {} removed due to connection timeout", (Object)sessionId);
                    }
                }, AuthorizeHandler.this.configuration.getCloseTimeout(), TimeUnit.SECONDS);
            }
        });
    }

    public boolean isSessionAuthorized(UUID sessionId) {
        return this.authorizedSessionIds.contains(sessionId);
    }

    public void connect(MainBaseClient client) {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.AUTHORIZE, client.getSessionId());
        this.disconnectScheduler.cancel(key);
        client.send(new Packet(PacketType.CONNECT));
        Namespace ns = this.namespacesHub.get("");
        SocketIOClient nsClient = client.getChildClient(ns);
        this.namespacesHub.get(ns.getName()).onConnect(nsClient);
    }

    @Override
    public void onDisconnect(MainBaseClient client) {
        this.authorizedSessionIds.remove(client.getSessionId());
    }
}

