/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnConnectScanner;
import com.corundumstudio.socketio.annotation.OnDisconnectScanner;
import com.corundumstudio.socketio.annotation.OnEventScanner;
import com.corundumstudio.socketio.annotation.OnJsonObjectScanner;
import com.corundumstudio.socketio.annotation.OnMessageScanner;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class ScannerEngine {
    private static final List<? extends AnnotationScanner> annotations = Arrays.asList(new OnConnectScanner(), new OnDisconnectScanner(), new OnEventScanner(), new OnJsonObjectScanner(), new OnMessageScanner());

    public void scan(Namespace namespace, Object object, Class<?> clazz) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            for (AnnotationScanner annotationScanner : annotations) {
                if (!method.isAnnotationPresent(annotationScanner.getScanAnnotation())) continue;
                annotationScanner.validate(method, clazz);
                this.makeAccessible(method);
                annotationScanner.addListener(namespace, object, clazz, method);
            }
        }
        if (clazz.getSuperclass() != null) {
            this.scan(namespace, object, clazz.getSuperclass());
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                this.scan(namespace, object, (Class<?>)genericDeclaration);
            }
        }
    }

    private void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }
}

