/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDisconnectScanner
implements AnnotationScanner {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnDisconnect.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, Class clazz, final Method method) {
        namespace.addDisconnectListener(new DisconnectListener(){

            @Override
            public void onDisconnect(SocketIOClient client) {
                try {
                    method.invoke(object, client);
                }
                catch (Exception e) {
                    throw new SocketIOException(e);
                }
            }
        });
    }

    @Override
    public void validate(Method method, Class clazz) {
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Wrong OnDisconnect listener signature: " + clazz + "." + method.getName());
        }
        boolean valid = false;
        for (Class<?> eventType : method.getParameterTypes()) {
            if (!eventType.equals(SocketIOClient.class)) continue;
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("Wrong OnDisconnect listener signature: " + clazz + "." + method.getName());
        }
    }
}

