/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.parser.AckArgs;
import com.corundumstudio.socketio.parser.JsonSupport;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonSupportWrapper
implements JsonSupport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JsonSupport delegate;

    JsonSupportWrapper(JsonSupport delegate) {
        this.delegate = delegate;
    }

    @Override
    public AckArgs readAckArgs(ByteBufInputStream src, Class<?> argType) throws IOException {
        try {
            return this.delegate.readAckArgs(src, argType);
        }
        catch (IOException e) {
            src.reset();
            this.log.error("Can't read ack args: " + src.readLine() + " for type: " + argType, (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            src.reset();
            this.log.error("Can't read ack args: " + src.readLine() + " for type: " + argType, (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T readValue(ByteBufInputStream src, Class<T> valueType) throws IOException {
        try {
            return this.delegate.readValue(src, valueType);
        }
        catch (IOException e) {
            src.reset();
            this.log.error("Can't read value 1: " + src.readLine() + " for type: " + valueType, (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            src.reset();
            this.log.error("Can't read value 2: " + src.readLine() + " for type: " + valueType, (Throwable)e);
            return null;
        }
    }

    @Override
    public void writeValue(ByteBufOutputStream out, Object value) throws IOException {
        try {
            this.delegate.writeValue(out, value);
        }
        catch (IOException e) {
            this.log.error("Can't write value: " + value, (Throwable)e);
        }
        catch (RuntimeException e) {
            this.log.error("Can't write value: " + value, (Throwable)e);
        }
    }

    @Override
    public String writeValueAsString(Object value) throws IOException {
        try {
            return this.delegate.writeValueAsString(value);
        }
        catch (IOException e) {
            this.log.error("Can't convert value to string: " + value, (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            this.log.error("Can't convert value to string: " + value, (Throwable)e);
            return null;
        }
    }

    @Override
    public void addEventMapping(String eventName, Class<?> eventClass) {
        this.delegate.addEventMapping(eventName, eventClass);
    }

    @Override
    public void addJsonClass(Class<?> clazz) {
        this.delegate.addJsonClass(clazz);
    }

    @Override
    public void removeEventMapping(String eventName) {
        this.delegate.removeEventMapping(eventName);
    }

    @Override
    public <T> T readValue(String src, Class<T> valueType) throws IOException {
        return this.delegate.readValue(src, valueType);
    }
}

