/*
 * Decompiled with CFR 0.152.
 */
package com.cordial.util;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.Size;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.view.inputmethod.InputMethodManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a8\u0006\u000f"}, d2={"Lcom/cordial/util/ScreenUtils;", "", "Landroid/content/Context;", "context", "", "getScreenWidth", "getScreenHeight", "windowWidth", "getInitialScaleByWidth", "windowHeight", "getInitialScaleByHeight", "Landroid/view/View;", "view", "", "hideKeyboard", "cordialsdk_release"})
public final class ScreenUtils {
    @NotNull
    public static final ScreenUtils INSTANCE = new ScreenUtils();

    public static Size a(Context context) {
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowMetrics windowMetrics = ((WindowManager)object).getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"getCurrentWindowMetrics(...)");
        WindowInsets windowInsets = windowMetrics.getWindowInsets();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"getWindowInsets(...)");
        context = windowInsets.getInsetsIgnoringVisibility(WindowInsets.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getInsetsIgnoringVisibility(...)");
        int n2 = context.right + context.left;
        int n3 = context.top + context.bottom;
        Rect rect = windowMetrics.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        return new Size(rect.width() - n2, rect.height() - n3);
    }

    public final int getScreenWidth(@NotNull Context context) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 30) {
            n2 = ScreenUtils.a((Context)var1_1).getWidth();
        } else {
            Point point;
            Object object = var1_1.getSystemService("window");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
            ScreenUtils screenUtils = ((WindowManager)object).getDefaultDisplay();
            var1_1 = point;
            point = new Point();
            if (screenUtils != null) {
                screenUtils.getRealSize(var1_1);
            }
            n2 = var1_1.x;
        }
        return n2;
    }

    public final int getScreenHeight(@NotNull Context context) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 30) {
            n2 = ScreenUtils.a((Context)var1_1).getHeight();
        } else {
            Point point;
            Object object = var1_1.getSystemService("window");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
            ScreenUtils screenUtils = ((WindowManager)object).getDefaultDisplay();
            var1_1 = point;
            point = new Point();
            if (screenUtils != null) {
                screenUtils.getRealSize(var1_1);
            }
            n2 = var1_1.y;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getInitialScaleByWidth(@NotNull Context context, int windowWidth) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        return windowWidth * 100 / this.getScreenWidth((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getInitialScaleByHeight(@NotNull Context context, int windowHeight) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        return windowHeight * 100 / this.getScreenHeight((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void hideKeyboard(@NotNull View view, @NotNull Context context) {
        void var1_1;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = context2.getSystemService("input_method");
        object = object instanceof InputMethodManager ? (InputMethodManager)object : null;
        if (object != null) {
            object.hideSoftInputFromWindow(var1_1.getWindowToken(), 0);
        }
    }
}

