/*
 * Decompiled with CFR 0.152.
 */
package com.cordial.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Build;
import com.cordial.network.ConnectionStateMonitor;
import com.cordial.network.NetworkState;
import com.cordial.network.OnConnectivityListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/cordial/network/NetworkStateListener;", "Lcom/cordial/network/NetworkState;", "()V", "isNetworkAvailable", "", "context", "Landroid/content/Context;", "register", "", "onConnectivityListener", "Lcom/cordial/network/OnConnectivityListener;", "unregister", "cordialsdk_release"})
public final class NetworkStateListener
implements NetworkState {
    /*
     * WARNING - void declaration
     */
    @Override
    public void register(@NotNull Context context, @NotNull OnConnectivityListener onConnectivityListener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)onConnectivityListener, (String)"onConnectivityListener");
        new ConnectionStateMonitor((OnConnectivityListener)var2_2).enable((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregister(@NotNull Context context, @NotNull OnConnectivityListener onConnectivityListener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)onConnectivityListener, (String)"onConnectivityListener");
        new ConnectionStateMonitor((OnConnectivityListener)var2_2).disable((Context)var1_1);
    }

    @Override
    public boolean isNetworkAvailable(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        NetworkStateListener networkStateListener = (ConnectivityManager)context2.getSystemService("connectivity");
        if (networkStateListener != null) {
            if (Build.VERSION.SDK_INT < 23) {
                return (networkStateListener = networkStateListener.getActiveNetworkInfo()) != null && networkStateListener.isConnected();
            }
            Network network = networkStateListener.getActiveNetwork();
            if (network != null && (networkStateListener = networkStateListener.getNetworkCapabilities(network)) != null) {
                return networkStateListener.hasTransport(0) || networkStateListener.hasTransport(1);
            }
        }
        return false;
    }
}

