/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import java.util.concurrent.atomic.LongAdder;
import sun.misc.Contended;

public class PushPullConcurrentQueue<E>
implements ConcurrentQueue<E> {
    final int size;
    final long mask;
    final LongAdder tail = new LongAdder();
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    @Contended
    long tailCache = 0L;
    long a1;
    long a2;
    long a3;
    long a4;
    long a5;
    long a6;
    long a7;
    long a8;
    final E[] buffer;
    long r1;
    long r2;
    long r3;
    long r4;
    long r5;
    long r6;
    long r7;
    @Contended
    long headCache = 0L;
    long c1;
    long c2;
    long c3;
    long c4;
    long c5;
    long c6;
    long c7;
    long c8;
    final LongAdder head = new LongAdder();

    public PushPullConcurrentQueue(int size) {
        int rs;
        for (rs = 1; rs < size; rs <<= 1) {
        }
        this.size = rs;
        this.mask = rs - 1;
        this.buffer = new Object[this.size];
    }

    @Override
    public boolean offer(E e) {
        if (e != null) {
            long tail = this.tail.sum();
            long queueStart = tail - (long)this.size;
            if (this.headCache > queueStart || (this.headCache = this.head.sum()) > queueStart) {
                int dx = (int)(tail & this.mask);
                this.buffer[dx] = e;
                this.tail.increment();
                return true;
            }
            return false;
        }
        throw new NullPointerException("Invalid element");
    }

    @Override
    public E poll() {
        long head = this.head.sum();
        if (head < this.tailCache || head < (this.tailCache = this.tail.sum())) {
            int dx = (int)(head & this.mask);
            E e = this.buffer[dx];
            this.buffer[dx] = null;
            this.head.increment();
            return e;
        }
        return null;
    }

    @Override
    public int remove(E[] e) {
        int n = 0;
        this.headCache = this.head.sum();
        int nMax = e.length;
        long end = this.tail.sum();
        for (long i = this.headCache; n < nMax && i < end; ++i) {
            int dx = (int)(i & this.mask);
            e[n++] = this.buffer[dx];
            this.buffer[dx] = null;
        }
        this.head.add(n);
        return n;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.head.add(this.tail.sum() - this.head.sum());
    }

    @Override
    public final E peek() {
        return this.buffer[(int)(this.head.sum() & this.mask)];
    }

    @Override
    public final int size() {
        return (int)Math.max(this.tail.sum() - this.head.sum(), 0L);
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.tail.sum() == this.head.sum();
    }

    @Override
    public final boolean contains(Object o) {
        if (o != null) {
            long end = this.tail.sum();
            for (long i = this.head.sum(); i < end; ++i) {
                E e = this.buffer[(int)(i & this.mask)];
                if (!o.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    long sumToAvoidOptimization() {
        return this.p1 + this.p2 + this.p3 + this.p4 + this.p5 + this.p6 + this.p7 + this.a1 + this.a2 + this.a3 + this.a4 + this.a5 + this.a6 + this.a7 + this.a8 + this.r1 + this.r2 + this.r3 + this.r4 + this.r5 + this.r6 + this.r7 + this.c1 + this.c2 + this.c3 + this.c4 + this.c5 + this.c6 + this.c7 + this.c8 + this.headCache + this.tailCache;
    }
}

