/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.AbstractQueueCondition;
import com.conversantmedia.util.concurrent.AbstractWaitingQueueCondition;
import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.PushPullConcurrentQueue;
import com.conversantmedia.util.concurrent.QueueCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class PushPullBlockingQueue<E>
extends PushPullConcurrentQueue<E>
implements Serializable,
Iterable<E>,
Collection<E>,
BlockingQueue<E>,
Queue<E>,
ConcurrentQueue<E> {
    protected final QueueCondition queueNotFullCondition;
    protected final QueueCondition queueNotEmptyCondition;

    public PushPullBlockingQueue(int capacity) {
        this(capacity, true);
    }

    public PushPullBlockingQueue(int capacity, boolean useWaitingLocking) {
        super(capacity);
        if (useWaitingLocking) {
            this.queueNotFullCondition = new WaitingQueueNotFull();
            this.queueNotEmptyCondition = new WaitingQueueNotEmpty();
        } else {
            this.queueNotFullCondition = new QueueNotFull();
            this.queueNotEmptyCondition = new QueueNotEmpty();
        }
    }

    public PushPullBlockingQueue(int capacity, Collection<? extends E> c) {
        this(capacity);
        for (E e : c) {
            this.offer(e);
        }
    }

    @Override
    public final boolean offer(E e) {
        if (super.offer(e)) {
            this.queueNotEmptyCondition.signal();
            return true;
        }
        this.queueNotEmptyCondition.signal();
        return false;
    }

    @Override
    public final E poll() {
        Object e = super.poll();
        this.queueNotFullCondition.signal();
        return e;
    }

    @Override
    public int remove(E[] e) {
        int n = super.remove(e);
        this.queueNotFullCondition.signal();
        return n;
    }

    @Override
    public E remove() {
        return this.poll();
    }

    @Override
    public E element() {
        Object val = this.peek();
        if (val != null) {
            return val;
        }
        throw new NoSuchElementException("No element found.");
    }

    @Override
    public void put(E e) throws InterruptedException {
        while (!this.offer(e)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LockSupport.parkNanos(50L);
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        do {
            if (!this.offer(e)) continue;
            return true;
        } while (this.waitStatus(timeout, unit, this.queueNotFullCondition));
        return false;
    }

    @Override
    public E take() throws InterruptedException {
        E pollObj;
        while ((pollObj = this.poll()) == null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LockSupport.parkNanos(50L);
        }
        return pollObj;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        do {
            E pollObj;
            if ((pollObj = this.poll()) == null) continue;
            return pollObj;
        } while (this.waitStatus(timeout, unit, this.queueNotEmptyCondition));
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.queueNotFullCondition.signal();
    }

    @Override
    public int remainingCapacity() {
        return this.size - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, this.size());
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (this == c) {
            throw new IllegalArgumentException("Can not drain to self.");
        }
        Object[] pollObj = new Object[Math.min(this.size(), maxElements)];
        int nEle = this.remove(pollObj);
        int nRead = 0;
        for (int i = 0; i < nEle; ++i) {
            if (!c.add(pollObj[i])) continue;
            ++nRead;
        }
        return nRead;
    }

    @Override
    public Object[] toArray() {
        Object[] e = new Object[this.size()];
        this.toArray(e);
        return e;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.remove(a);
        return a;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("queue is full");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            if (this.offer(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int numFalses = 0;
        for (Object o : c) {
            if (this.remove(o)) continue;
            ++numFalses;
        }
        return numFalses > 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int numFalses = 0;
        for (int i = 0; i < this.size(); ++i) {
            int headSlot = (int)(this.head.get() + (long)i & this.mask);
            if (c.contains(this.buffer[headSlot])) continue;
            if (!this.remove(this.buffer[headSlot])) {
                ++numFalses;
                continue;
            }
            --i;
        }
        return numFalses > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIter();
    }

    protected final boolean waitStatus(long timeout, TimeUnit unit, QueueCondition condition) throws InterruptedException {
        long timeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long expireTime = System.nanoTime() + timeoutNanos;
        while (condition.test()) {
            if (System.nanoTime() > expireTime) {
                return false;
            }
            condition.awaitNanos(timeoutNanos);
        }
        return true;
    }

    private final class WaitingQueueNotEmpty
    extends AbstractWaitingQueueCondition {
        private WaitingQueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return PushPullBlockingQueue.this.tail.get() == PushPullBlockingQueue.this.head.get();
        }
    }

    private final class WaitingQueueNotFull
    extends AbstractWaitingQueueCondition {
        private WaitingQueueNotFull() {
        }

        @Override
        public final boolean test() {
            long queueStart = PushPullBlockingQueue.this.tail.get() - (long)PushPullBlockingQueue.this.size;
            return PushPullBlockingQueue.this.headCache.value == queueStart || (PushPullBlockingQueue.this.headCache.value = PushPullBlockingQueue.this.head.get()) == queueStart;
        }
    }

    private final class QueueNotEmpty
    extends AbstractQueueCondition {
        private QueueNotEmpty() {
        }

        @Override
        public final boolean test() {
            return PushPullBlockingQueue.this.tail.get() == PushPullBlockingQueue.this.head.get();
        }
    }

    private final class QueueNotFull
    extends AbstractQueueCondition {
        private QueueNotFull() {
        }

        @Override
        public final boolean test() {
            long queueStart = PushPullBlockingQueue.this.tail.get() - (long)PushPullBlockingQueue.this.size;
            return PushPullBlockingQueue.this.headCache.value == queueStart || (PushPullBlockingQueue.this.headCache.value = PushPullBlockingQueue.this.head.get()) == queueStart;
        }
    }

    private final class RingIter
    implements Iterator<E> {
        int dx = 0;
        E lastObj = null;

        private RingIter() {
        }

        @Override
        public boolean hasNext() {
            return this.dx < PushPullBlockingQueue.this.size();
        }

        @Override
        public E next() {
            long pollPos = PushPullBlockingQueue.this.head.get();
            int slot = (int)(pollPos + (long)this.dx++ & PushPullBlockingQueue.this.mask);
            this.lastObj = PushPullBlockingQueue.this.buffer[slot];
            return this.lastObj;
        }

        @Override
        public void remove() {
            PushPullBlockingQueue.this.remove(this.lastObj);
        }
    }
}

