/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.collection.Stack;
import com.conversantmedia.util.concurrent.PaddedAtomicInteger;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentStack<N>
implements Stack<N> {
    private final int size;
    private final N[] stack;
    private final AtomicInteger stackTop = new PaddedAtomicInteger(0);
    private final AtomicInteger stackCursor = new PaddedAtomicInteger(0);

    public ConcurrentStack(int size) {
        int stackSize;
        for (stackSize = 1; stackSize < size; stackSize <<= 1) {
        }
        this.size = stackSize;
        this.stack = new Object[stackSize];
    }

    @Override
    public void push(N n) {
        while (!this.add(n)) {
            Thread.yield();
        }
    }

    @Override
    public boolean contains(N n) {
        if (n != null) {
            for (int i = 0; i < this.stackTop.get(); ++i) {
                if (!n.equals(this.stack[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(N n) {
        while (true) {
            int stackTop;
            if (this.size > (stackTop = this.stackTop.get())) {
                int nextTop = stackTop + 1;
                if (this.stackCursor.compareAndSet(stackTop, nextTop)) {
                    try {
                        this.stack[stackTop] = n;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.stackTop.lazySet(nextTop);
                    }
                }
            } else {
                return false;
            }
            Thread.yield();
        }
    }

    @Override
    public N peek() {
        int stackTop = this.stackTop.get();
        if (stackTop > 0) {
            return this.stack[stackTop - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N pop() {
        while (true) {
            int stackTop;
            if ((stackTop = this.stackTop.get()) > 0) {
                int lastRef = stackTop - 1;
                if (this.stackCursor.compareAndSet(stackTop, lastRef)) {
                    try {
                        N n = this.stack[lastRef];
                        this.stack[lastRef] = null;
                        N n2 = n;
                        return n2;
                    }
                    finally {
                        this.stackTop.lazySet(lastRef);
                    }
                }
            } else {
                return null;
            }
            Thread.yield();
        }
    }

    @Override
    public int size() {
        return this.stackTop.get();
    }

    @Override
    public int remainingCapacity() {
        return this.size - this.stackTop.get();
    }

    @Override
    public boolean isEmpty() {
        return this.stackTop.get() == 0;
    }

    @Override
    public void clear() {
        while (true) {
            int stackTop;
            if ((stackTop = this.stackTop.get()) > 0) {
                if (this.stackCursor.compareAndSet(stackTop, 0)) {
                    try {
                        for (int i = 0; i < stackTop; ++i) {
                            this.stack[i] = null;
                        }
                        return;
                    }
                    finally {
                        this.stackTop.lazySet(0);
                    }
                }
            } else {
                return;
            }
            Thread.yield();
        }
    }

    public static final class OverflowException
    extends Exception {
        private OverflowException() {
        }
    }
}

