/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.QueueCondition;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractQueueCondition
implements QueueCondition {
    private final ReentrantLock queueLock = new ReentrantLock();
    private final Condition queueCondition = this.queueLock.newCondition();

    AbstractQueueCondition() {
    }

    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        this.queueLock.lock();
        try {
            this.queueCondition.awaitNanos(timeout);
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.queueLock.lock();
        try {
            this.queueCondition.await();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void signal() {
        this.queueLock.lock();
        try {
            this.queueCondition.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

