/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.view.View;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.adapter.NumericWheelAdapter;
import com.bigkoo.pickerview.lib.WheelView;
import com.bigkoo.pickerview.listener.OnItemSelectedListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class WheelTime {
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private View view;
    private WheelView wv_year;
    private WheelView wv_month;
    private WheelView wv_day;
    private WheelView wv_hours;
    private WheelView wv_mins;
    private WheelView wv_seconds;
    private int gravity;
    private boolean[] type;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int DEFAULT_START_MONTH = 1;
    private static final int DEFAULT_END_MONTH = 12;
    private static final int DEFAULT_START_DAY = 1;
    private static final int DEFAULT_END_DAY = 31;
    private int startYear = 1900;
    private int endYear = 2100;
    private int startMonth = 1;
    private int endMonth = 12;
    private int startDay = 1;
    private int endDay = 31;
    private int currentYear;
    private int textSize = 18;
    int textColorOut;
    int textColorCenter;
    int dividerColor;
    float lineSpacingMultiplier = 1.6f;
    private WheelView.DividerType dividerType;

    public WheelTime(View view) {
        this.view = view;
        this.type = new boolean[]{true, true, true, true, true, true};
        this.setView(view);
    }

    public WheelTime(View view, boolean[] type, int gravity, int textSize) {
        this.view = view;
        this.type = type;
        this.gravity = gravity;
        this.textSize = textSize;
        this.setView(view);
    }

    public void setPicker(int year, int month, int day) {
        this.setPicker(year, month, day, 0, 0, 0);
    }

    public void setPicker(int year, int month, int day, int h, int m, int s) {
        String[] months_big = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] months_little = new String[]{"4", "6", "9", "11"};
        final List<String> list_big = Arrays.asList(months_big);
        final List<String> list_little = Arrays.asList(months_little);
        this.currentYear = year;
        this.wv_year = (WheelView)this.view.findViewById(R.id.year);
        this.wv_year.setAdapter(new NumericWheelAdapter(this.startYear, this.endYear));
        this.wv_year.setCurrentItem(year - this.startYear);
        this.wv_year.setGravity(this.gravity);
        this.wv_month = (WheelView)this.view.findViewById(R.id.month);
        if (this.startYear == this.endYear) {
            this.wv_month.setAdapter(new NumericWheelAdapter(this.startMonth, this.endMonth));
            this.wv_month.setCurrentItem(month + 1 - this.startMonth);
        } else if (year == this.startYear) {
            this.wv_month.setAdapter(new NumericWheelAdapter(this.startMonth, 12));
            this.wv_month.setCurrentItem(month + 1 - this.startMonth);
        } else if (year == this.endYear) {
            this.wv_month.setAdapter(new NumericWheelAdapter(1, this.endMonth));
            this.wv_month.setCurrentItem(month);
        } else {
            this.wv_month.setAdapter(new NumericWheelAdapter(1, 12));
            this.wv_month.setCurrentItem(month);
        }
        this.wv_month.setGravity(this.gravity);
        this.wv_day = (WheelView)this.view.findViewById(R.id.day);
        if (this.startYear == this.endYear && this.startMonth == this.endMonth) {
            if (list_big.contains(String.valueOf(month + 1))) {
                if (this.endDay > 31) {
                    this.endDay = 31;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, this.endDay));
            } else if (list_little.contains(String.valueOf(month + 1))) {
                if (this.endDay > 30) {
                    this.endDay = 30;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, this.endDay));
            } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                if (this.endDay > 29) {
                    this.endDay = 29;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, this.endDay));
            } else {
                if (this.endDay > 28) {
                    this.endDay = 28;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, this.endDay));
            }
            this.wv_day.setCurrentItem(day - this.startDay);
        } else if (year == this.startYear && month + 1 == this.startMonth) {
            if (list_big.contains(String.valueOf(month + 1))) {
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, 31));
            } else if (list_little.contains(String.valueOf(month + 1))) {
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, 30));
            } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, 29));
            } else {
                this.wv_day.setAdapter(new NumericWheelAdapter(this.startDay, 28));
            }
            this.wv_day.setCurrentItem(day - this.startDay);
        } else if (year == this.endYear && month + 1 == this.endMonth) {
            if (list_big.contains(String.valueOf(month + 1))) {
                if (this.endDay > 31) {
                    this.endDay = 31;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(1, this.endDay));
            } else if (list_little.contains(String.valueOf(month + 1))) {
                if (this.endDay > 30) {
                    this.endDay = 30;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(1, this.endDay));
            } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                if (this.endDay > 29) {
                    this.endDay = 29;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(1, this.endDay));
            } else {
                if (this.endDay > 28) {
                    this.endDay = 28;
                }
                this.wv_day.setAdapter(new NumericWheelAdapter(1, this.endDay));
            }
            this.wv_day.setCurrentItem(day - 1);
        } else {
            if (list_big.contains(String.valueOf(month + 1))) {
                this.wv_day.setAdapter(new NumericWheelAdapter(1, 31));
            } else if (list_little.contains(String.valueOf(month + 1))) {
                this.wv_day.setAdapter(new NumericWheelAdapter(1, 30));
            } else if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                this.wv_day.setAdapter(new NumericWheelAdapter(1, 29));
            } else {
                this.wv_day.setAdapter(new NumericWheelAdapter(1, 28));
            }
            this.wv_day.setCurrentItem(day - 1);
        }
        this.wv_day.setGravity(this.gravity);
        this.wv_hours = (WheelView)this.view.findViewById(R.id.hour);
        this.wv_hours.setAdapter(new NumericWheelAdapter(0, 23));
        this.wv_hours.setCurrentItem(h);
        this.wv_hours.setGravity(this.gravity);
        this.wv_mins = (WheelView)this.view.findViewById(R.id.min);
        this.wv_mins.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_mins.setCurrentItem(m);
        this.wv_mins.setGravity(this.gravity);
        this.wv_seconds = (WheelView)this.view.findViewById(R.id.second);
        this.wv_seconds.setAdapter(new NumericWheelAdapter(0, 59));
        this.wv_seconds.setCurrentItem(s);
        this.wv_seconds.setGravity(this.gravity);
        OnItemSelectedListener wheelListener_year = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int year_num = index + WheelTime.this.startYear;
                WheelTime.this.currentYear = year_num;
                int currentMonthItem = WheelTime.this.wv_month.getCurrentItem();
                if (WheelTime.this.startYear == WheelTime.this.endYear) {
                    WheelTime.this.wv_month.setAdapter(new NumericWheelAdapter(WheelTime.this.startMonth, WheelTime.this.endMonth));
                    if (currentMonthItem > WheelTime.this.wv_month.getAdapter().getItemsCount() - 1) {
                        currentMonthItem = WheelTime.this.wv_month.getAdapter().getItemsCount() - 1;
                        WheelTime.this.wv_month.setCurrentItem(currentMonthItem);
                    }
                    int monthNum = currentMonthItem + WheelTime.this.startMonth;
                    if (WheelTime.this.startMonth == WheelTime.this.endMonth) {
                        WheelTime.this.setReDay(year_num, monthNum, WheelTime.this.startDay, WheelTime.this.endDay, list_big, list_little);
                    } else if (monthNum == WheelTime.this.startMonth) {
                        WheelTime.this.setReDay(year_num, monthNum, WheelTime.this.startDay, 31, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(year_num, monthNum, 1, 31, list_big, list_little);
                    }
                } else if (year_num == WheelTime.this.startYear) {
                    int month;
                    WheelTime.this.wv_month.setAdapter(new NumericWheelAdapter(WheelTime.this.startMonth, 12));
                    if (currentMonthItem > WheelTime.this.wv_month.getAdapter().getItemsCount() - 1) {
                        currentMonthItem = WheelTime.this.wv_month.getAdapter().getItemsCount() - 1;
                        WheelTime.this.wv_month.setCurrentItem(currentMonthItem);
                    }
                    if ((month = currentMonthItem + WheelTime.this.startMonth) == WheelTime.this.startMonth) {
                        WheelTime.this.setReDay(year_num, month, WheelTime.this.startDay, 31, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(year_num, month, 1, 31, list_big, list_little);
                    }
                } else if (year_num == WheelTime.this.endYear) {
                    int monthNum;
                    WheelTime.this.wv_month.setAdapter(new NumericWheelAdapter(1, WheelTime.this.endMonth));
                    if (currentMonthItem > WheelTime.this.wv_month.getAdapter().getItemsCount() - 1) {
                        currentMonthItem = WheelTime.this.wv_month.getAdapter().getItemsCount() - 1;
                        WheelTime.this.wv_month.setCurrentItem(currentMonthItem);
                    }
                    if ((monthNum = currentMonthItem + 1) == WheelTime.this.endMonth) {
                        WheelTime.this.setReDay(year_num, monthNum, 1, WheelTime.this.endDay, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(year_num, monthNum, 1, 31, list_big, list_little);
                    }
                } else {
                    WheelTime.this.wv_month.setAdapter(new NumericWheelAdapter(1, 12));
                    WheelTime.this.setReDay(year_num, WheelTime.this.wv_month.getCurrentItem() + 1, 1, 31, list_big, list_little);
                }
            }
        };
        OnItemSelectedListener wheelListener_month = new OnItemSelectedListener(){

            @Override
            public void onItemSelected(int index) {
                int month_num = index + 1;
                if (WheelTime.this.startYear == WheelTime.this.endYear) {
                    month_num = month_num + WheelTime.this.startMonth - 1;
                    if (WheelTime.this.startMonth == WheelTime.this.endMonth) {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, WheelTime.this.startDay, WheelTime.this.endDay, list_big, list_little);
                    } else if (WheelTime.this.startMonth == month_num) {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, WheelTime.this.startDay, 31, list_big, list_little);
                    } else if (WheelTime.this.endMonth == month_num) {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, 1, WheelTime.this.endDay, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, 1, 31, list_big, list_little);
                    }
                } else if (WheelTime.this.currentYear == WheelTime.this.startYear) {
                    if ((month_num = month_num + WheelTime.this.startMonth - 1) == WheelTime.this.startMonth) {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, WheelTime.this.startDay, 31, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, 1, 31, list_big, list_little);
                    }
                } else if (WheelTime.this.currentYear == WheelTime.this.endYear) {
                    if (month_num == WheelTime.this.endMonth) {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, WheelTime.this.wv_month.getCurrentItem() + 1, 1, WheelTime.this.endDay, list_big, list_little);
                    } else {
                        WheelTime.this.setReDay(WheelTime.this.currentYear, WheelTime.this.wv_month.getCurrentItem() + 1, 1, 31, list_big, list_little);
                    }
                } else {
                    WheelTime.this.setReDay(WheelTime.this.currentYear, month_num, 1, 31, list_big, list_little);
                }
            }
        };
        this.wv_year.setOnItemSelectedListener(wheelListener_year);
        this.wv_month.setOnItemSelectedListener(wheelListener_month);
        if (this.type.length != 6) {
            throw new RuntimeException("type[] length is not 6");
        }
        this.wv_year.setVisibility(this.type[0] ? 0 : 8);
        this.wv_month.setVisibility(this.type[1] ? 0 : 8);
        this.wv_day.setVisibility(this.type[2] ? 0 : 8);
        this.wv_hours.setVisibility(this.type[3] ? 0 : 8);
        this.wv_mins.setVisibility(this.type[4] ? 0 : 8);
        this.wv_seconds.setVisibility(this.type[5] ? 0 : 8);
        this.setContentTextSize();
    }

    private void setReDay(int year_num, int monthNum, int startD, int endD, List<String> list_big, List<String> list_little) {
        int currentItem = this.wv_day.getCurrentItem();
        if (list_big.contains(String.valueOf(monthNum))) {
            if (endD > 31) {
                endD = 31;
            }
            this.wv_day.setAdapter(new NumericWheelAdapter(startD, endD));
            int maxItem = endD;
        } else if (list_little.contains(String.valueOf(monthNum))) {
            if (endD > 30) {
                endD = 30;
            }
            this.wv_day.setAdapter(new NumericWheelAdapter(startD, endD));
            int maxItem = endD;
        } else if (year_num % 4 == 0 && year_num % 100 != 0 || year_num % 400 == 0) {
            if (endD > 29) {
                endD = 29;
            }
            this.wv_day.setAdapter(new NumericWheelAdapter(startD, endD));
            int maxItem = endD;
        } else {
            if (endD > 28) {
                endD = 28;
            }
            this.wv_day.setAdapter(new NumericWheelAdapter(startD, endD));
            int maxItem = endD;
        }
        if (currentItem > this.wv_day.getAdapter().getItemsCount() - 1) {
            currentItem = this.wv_day.getAdapter().getItemsCount() - 1;
            this.wv_day.setCurrentItem(currentItem);
        }
    }

    private void setContentTextSize() {
        this.wv_day.setTextSize(this.textSize);
        this.wv_month.setTextSize(this.textSize);
        this.wv_year.setTextSize(this.textSize);
        this.wv_hours.setTextSize(this.textSize);
        this.wv_mins.setTextSize(this.textSize);
        this.wv_seconds.setTextSize(this.textSize);
    }

    private void setTextColorOut() {
        this.wv_day.setTextColorOut(this.textColorOut);
        this.wv_month.setTextColorOut(this.textColorOut);
        this.wv_year.setTextColorOut(this.textColorOut);
        this.wv_hours.setTextColorOut(this.textColorOut);
        this.wv_mins.setTextColorOut(this.textColorOut);
        this.wv_seconds.setTextColorOut(this.textColorOut);
    }

    private void setTextColorCenter() {
        this.wv_day.setTextColorCenter(this.textColorCenter);
        this.wv_month.setTextColorCenter(this.textColorCenter);
        this.wv_year.setTextColorCenter(this.textColorCenter);
        this.wv_hours.setTextColorCenter(this.textColorCenter);
        this.wv_mins.setTextColorCenter(this.textColorCenter);
        this.wv_seconds.setTextColorCenter(this.textColorCenter);
    }

    private void setDividerColor() {
        this.wv_day.setDividerColor(this.dividerColor);
        this.wv_month.setDividerColor(this.dividerColor);
        this.wv_year.setDividerColor(this.dividerColor);
        this.wv_hours.setDividerColor(this.dividerColor);
        this.wv_mins.setDividerColor(this.dividerColor);
        this.wv_seconds.setDividerColor(this.dividerColor);
    }

    private void setDividerType() {
        this.wv_day.setDividerType(this.dividerType);
        this.wv_month.setDividerType(this.dividerType);
        this.wv_year.setDividerType(this.dividerType);
        this.wv_hours.setDividerType(this.dividerType);
        this.wv_mins.setDividerType(this.dividerType);
        this.wv_seconds.setDividerType(this.dividerType);
    }

    private void setLineSpacingMultiplier() {
        this.wv_day.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_month.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_year.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_hours.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_mins.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wv_seconds.setLineSpacingMultiplier(this.lineSpacingMultiplier);
    }

    public void setLabels(String label_year, String label_month, String label_day, String label_hours, String label_mins, String label_seconds) {
        if (label_year != null) {
            this.wv_year.setLabel(label_year);
        } else {
            this.wv_year.setLabel(this.view.getContext().getString(R.string.pickerview_year));
        }
        if (label_month != null) {
            this.wv_month.setLabel(label_month);
        } else {
            this.wv_month.setLabel(this.view.getContext().getString(R.string.pickerview_month));
        }
        if (label_day != null) {
            this.wv_day.setLabel(label_day);
        } else {
            this.wv_day.setLabel(this.view.getContext().getString(R.string.pickerview_day));
        }
        if (label_hours != null) {
            this.wv_hours.setLabel(label_hours);
        } else {
            this.wv_hours.setLabel(this.view.getContext().getString(R.string.pickerview_hours));
        }
        if (label_mins != null) {
            this.wv_mins.setLabel(label_mins);
        } else {
            this.wv_mins.setLabel(this.view.getContext().getString(R.string.pickerview_minutes));
        }
        if (label_seconds != null) {
            this.wv_seconds.setLabel(label_seconds);
        } else {
            this.wv_seconds.setLabel(this.view.getContext().getString(R.string.pickerview_seconds));
        }
    }

    public void setCyclic(boolean cyclic) {
        this.wv_year.setCyclic(cyclic);
        this.wv_month.setCyclic(cyclic);
        this.wv_day.setCyclic(cyclic);
        this.wv_hours.setCyclic(cyclic);
        this.wv_mins.setCyclic(cyclic);
        this.wv_seconds.setCyclic(cyclic);
    }

    public String getTime() {
        StringBuffer sb = new StringBuffer();
        if (this.currentYear == this.startYear) {
            if (this.wv_month.getCurrentItem() + this.startMonth == this.startMonth) {
                sb.append(this.wv_year.getCurrentItem() + this.startYear).append("-").append(this.wv_month.getCurrentItem() + this.startMonth).append("-").append(this.wv_day.getCurrentItem() + this.startDay).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(":").append(this.wv_seconds.getCurrentItem());
            } else {
                sb.append(this.wv_year.getCurrentItem() + this.startYear).append("-").append(this.wv_month.getCurrentItem() + this.startMonth).append("-").append(this.wv_day.getCurrentItem() + 1).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(":").append(this.wv_seconds.getCurrentItem());
            }
        } else {
            sb.append(this.wv_year.getCurrentItem() + this.startYear).append("-").append(this.wv_month.getCurrentItem() + 1).append("-").append(this.wv_day.getCurrentItem() + 1).append(" ").append(this.wv_hours.getCurrentItem()).append(":").append(this.wv_mins.getCurrentItem()).append(":").append(this.wv_seconds.getCurrentItem());
        }
        return sb.toString();
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public void setRangDate(Calendar startDate, Calendar endDate) {
        if (startDate == null && endDate != null) {
            int year = endDate.get(1);
            int month = endDate.get(2) + 1;
            int day = endDate.get(5);
            if (year > this.startYear) {
                this.endYear = year;
                this.endMonth = month;
                this.endDay = day;
            } else if (year == this.startYear) {
                if (month > this.startMonth) {
                    this.endYear = year;
                    this.endMonth = month;
                    this.endDay = day;
                } else if (month == this.startMonth && month > this.startDay) {
                    this.endYear = year;
                    this.endMonth = month;
                    this.endDay = day;
                }
            }
        } else if (startDate != null && endDate == null) {
            int year = startDate.get(1);
            int month = startDate.get(2) + 1;
            int day = startDate.get(5);
            if (year < this.endYear) {
                this.startMonth = month;
                this.startDay = day;
                this.startYear = year;
            } else if (year == this.endYear) {
                if (month < this.endMonth) {
                    this.startMonth = month;
                    this.startDay = day;
                    this.startYear = year;
                } else if (month == this.endMonth && day < this.endDay) {
                    this.startMonth = month;
                    this.startDay = day;
                    this.startYear = year;
                }
            }
        } else if (startDate != null && endDate != null) {
            this.startYear = startDate.get(1);
            this.endYear = endDate.get(1);
            this.startMonth = startDate.get(2) + 1;
            this.endMonth = endDate.get(2) + 1;
            this.startDay = startDate.get(5);
            this.endDay = endDate.get(5);
        }
    }

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        this.setLineSpacingMultiplier();
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.setDividerColor();
    }

    public void setDividerType(WheelView.DividerType dividerType) {
        this.dividerType = dividerType;
        this.setDividerType();
    }

    public void setTextColorCenter(int textColorCenter) {
        this.textColorCenter = textColorCenter;
        this.setTextColorCenter();
    }

    public void setTextColorOut(int textColorOut) {
        this.textColorOut = textColorOut;
        this.setTextColorOut();
    }

    public void isCenterLabel(Boolean isCenterLabel) {
        this.wv_day.isCenterLabel(isCenterLabel);
        this.wv_month.isCenterLabel(isCenterLabel);
        this.wv_year.isCenterLabel(isCenterLabel);
        this.wv_hours.isCenterLabel(isCenterLabel);
        this.wv_mins.isCenterLabel(isCenterLabel);
        this.wv_seconds.isCenterLabel(isCenterLabel);
    }
}

