/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.WheelOptions;
import java.util.ArrayList;

public class OptionsPickerView<T>
extends BasePickerView
implements View.OnClickListener {
    WheelOptions<T> wheelOptions;
    private Button btnSubmit;
    private Button btnCancel;
    private TextView tvTitle;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";
    private OnOptionsSelectListener optionsSelectListener;
    private String Str_Submit;
    private String Str_Cancel;
    private String Str_Title;
    private int Color_Submit;
    private int Color_Cancel;
    private int Color_Title;
    private int Color_Background_Wheel;
    private int Color_Background_Title;
    private int Size_Submit_Cancel;
    private int Size_Title;
    private int Size_Content;
    private int textColorOut;
    private int textColorCenter;
    private int dividerColor;
    private float lineSpacingMultiplier = 1.6f;
    private boolean cancelable;
    private boolean linkage;
    private String label1;
    private String label2;
    private String label3;
    private boolean cyclic1;
    private boolean cyclic2;
    private boolean cyclic3;
    private int option1;
    private int option2;
    private int option3;

    public OptionsPickerView(Builder builder) {
        super(builder.context);
        this.optionsSelectListener = builder.optionsSelectListener;
        this.Str_Submit = builder.Str_Submit;
        this.Str_Cancel = builder.Str_Cancel;
        this.Str_Title = builder.Str_Title;
        this.Color_Submit = builder.Color_Submit;
        this.Color_Cancel = builder.Color_Cancel;
        this.Color_Title = builder.Color_Title;
        this.Color_Background_Wheel = builder.Color_Background_Wheel;
        this.Color_Background_Title = builder.Color_Background_Title;
        this.Size_Submit_Cancel = builder.Size_Submit_Cancel;
        this.Size_Title = builder.Size_Title;
        this.Size_Content = builder.Size_Content;
        this.cyclic1 = builder.cyclic1;
        this.cyclic2 = builder.cyclic2;
        this.cyclic3 = builder.cyclic3;
        this.cancelable = builder.cancelable;
        this.linkage = builder.linkage;
        this.label1 = builder.label1;
        this.label2 = builder.label2;
        this.label3 = builder.label3;
        this.option1 = builder.option1;
        this.option2 = builder.option2;
        this.option3 = builder.option3;
        this.textColorCenter = builder.textColorCenter;
        this.textColorOut = builder.textColorOut;
        this.dividerColor = builder.dividerColor;
        this.lineSpacingMultiplier = builder.lineSpacingMultiplier;
        this.initView(builder.context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.pickerview_options, this.contentContainer);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
        this.btnCancel = (Button)this.findViewById(R.id.btnCancel);
        this.btnSubmit.setTag((Object)TAG_SUBMIT);
        this.btnCancel.setTag((Object)TAG_CANCEL);
        this.btnSubmit.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.btnSubmit.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Submit) ? context.getResources().getString(R.string.pickerview_submit) : this.Str_Submit));
        this.btnCancel.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Cancel) ? context.getResources().getString(R.string.pickerview_cancel) : this.Str_Cancel));
        this.tvTitle.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Title) ? "" : this.Str_Title));
        this.btnSubmit.setTextColor(this.Color_Submit == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_timebtn_nor) : this.Color_Submit);
        this.btnCancel.setTextColor(this.Color_Cancel == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_timebtn_nor) : this.Color_Cancel);
        this.tvTitle.setTextColor(this.Color_Title == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_topbar_title) : this.Color_Title);
        this.btnSubmit.setTextSize((float)this.Size_Submit_Cancel);
        this.btnCancel.setTextSize((float)this.Size_Submit_Cancel);
        this.tvTitle.setTextSize((float)this.Size_Title);
        LinearLayout optionsPicker = (LinearLayout)this.findViewById(R.id.optionspicker);
        RelativeLayout rv_top_bar = (RelativeLayout)this.findViewById(R.id.rv_topbar);
        rv_top_bar.setBackgroundColor(this.Color_Background_Title == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_bg_topbar) : this.Color_Background_Title);
        optionsPicker.setBackgroundColor(this.Color_Background_Wheel == 0 ? ContextCompat.getColor((Context)context, (int)R.color.bgColor_default) : this.Color_Background_Wheel);
        this.wheelOptions = new WheelOptions((View)optionsPicker, this.linkage);
        this.wheelOptions.setTextContentSize(this.Size_Content);
        this.wheelOptions.setLabels(this.label1, this.label2, this.label3);
        this.wheelOptions.setCyclic(this.cyclic1, this.cyclic2, this.cyclic3);
        this.setOutSideCancelable(this.cancelable);
        this.tvTitle.setText((CharSequence)this.Str_Title);
        this.wheelOptions.setDividerColor(this.dividerColor);
        this.wheelOptions.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wheelOptions.setTextColorOut(this.textColorOut);
        this.wheelOptions.setTextColorCenter(this.textColorCenter);
    }

    public void setPicker(ArrayList<T> optionsItems) {
        this.wheelOptions.setPicker(optionsItems, null, null);
        this.wheelOptions.setCurrentItems(this.option1, this.option2, this.option3);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<ArrayList<T>> options2Items) {
        this.wheelOptions.setPicker(options1Items, options2Items, null);
        this.wheelOptions.setCurrentItems(this.option1, this.option2, this.option3);
    }

    public void setPicker(ArrayList<T> options1Items, ArrayList<ArrayList<T>> options2Items, ArrayList<ArrayList<ArrayList<T>>> options3Items) {
        this.wheelOptions.setPicker(options1Items, options2Items, options3Items);
        this.wheelOptions.setCurrentItems(this.option1, this.option2, this.option3);
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_CANCEL)) {
            this.dismiss();
            return;
        }
        if (this.optionsSelectListener != null) {
            int[] optionsCurrentItems = this.wheelOptions.getCurrentItems();
            this.optionsSelectListener.onOptionsSelect(optionsCurrentItems[0], optionsCurrentItems[1], optionsCurrentItems[2], v);
        }
        this.dismiss();
    }

    public static interface OnOptionsSelectListener {
        public void onOptionsSelect(int var1, int var2, int var3, View var4);
    }

    public static class Builder {
        private Context context;
        private OnOptionsSelectListener optionsSelectListener;
        private String Str_Submit;
        private String Str_Cancel;
        private String Str_Title;
        private int Color_Submit;
        private int Color_Cancel;
        private int Color_Title;
        private int Color_Background_Wheel;
        private int Color_Background_Title;
        private int Size_Submit_Cancel = 17;
        private int Size_Title = 18;
        private int Size_Content = 18;
        private boolean cancelable = true;
        private boolean linkage = true;
        private int textColorOut;
        private int textColorCenter;
        private int dividerColor;
        private float lineSpacingMultiplier = 1.6f;
        private String label1;
        private String label2;
        private String label3;
        private boolean cyclic1 = false;
        private boolean cyclic2 = false;
        private boolean cyclic3 = false;
        private int option1;
        private int option2;
        private int option3;

        public Builder(Context context, OnOptionsSelectListener listener) {
            this.context = context;
            this.optionsSelectListener = listener;
        }

        public Builder setSubmitText(String Str_Cancel) {
            this.Str_Submit = Str_Cancel;
            return this;
        }

        public Builder setCancelText(String Str_Cancel) {
            this.Str_Cancel = Str_Cancel;
            return this;
        }

        public Builder setTitleText(String Str_Title) {
            this.Str_Title = Str_Title;
            return this;
        }

        public Builder setSubmitColor(int Color_Submit) {
            this.Color_Submit = Color_Submit;
            return this;
        }

        public Builder setCancelColor(int Color_Cancel) {
            this.Color_Cancel = Color_Cancel;
            return this;
        }

        public Builder setBgColor(int Color_Background_Wheel) {
            this.Color_Background_Wheel = Color_Background_Wheel;
            return this;
        }

        public Builder setTitleBgColor(int Color_Background_Title) {
            this.Color_Background_Title = Color_Background_Title;
            return this;
        }

        public Builder setTitleColor(int Color_Title) {
            this.Color_Title = Color_Title;
            return this;
        }

        public Builder setSubCalSize(int Size_Submit_Cancel) {
            this.Size_Submit_Cancel = Size_Submit_Cancel;
            return this;
        }

        public Builder setTitleSize(int Size_Title) {
            this.Size_Title = Size_Title;
            return this;
        }

        public Builder setContentTextSize(int Size_Content) {
            this.Size_Content = Size_Content;
            return this;
        }

        public Builder setOutSideCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setLinkage(boolean linkage) {
            this.linkage = linkage;
            return this;
        }

        public Builder setLabels(String label1, String label2, String label3) {
            this.label1 = label1;
            this.label2 = label2;
            this.label3 = label3;
            return this;
        }

        public Builder setLineSpacingMultiplier(float lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            return this;
        }

        public Builder setDividerColor(int dividerColor) {
            this.dividerColor = dividerColor;
            return this;
        }

        public Builder setTextColorCenter(int textColorCenter) {
            this.textColorCenter = textColorCenter;
            return this;
        }

        public Builder setTextColorOut(int textColorOut) {
            this.textColorOut = textColorOut;
            return this;
        }

        public Builder setCyclic(boolean cyclic1, boolean cyclic2, boolean cyclic3) {
            this.cyclic1 = cyclic1;
            this.cyclic2 = cyclic2;
            this.cyclic3 = cyclic3;
            return this;
        }

        public Builder setSelectOptions(int option1) {
            this.option1 = option1;
            return this;
        }

        public Builder setSelectOptions(int option1, int option2) {
            this.option1 = option1;
            this.option2 = option2;
            return this;
        }

        public Builder setSelectOptions(int option1, int option2, int option3) {
            this.option1 = option1;
            this.option2 = option2;
            this.option3 = option3;
            return this;
        }

        public OptionsPickerView build() {
            return new OptionsPickerView(this);
        }
    }
}

