/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.listener.OnDismissListener;
import com.bigkoo.pickerview.utils.PickerViewAnimateUtil;

public class BasePickerView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private Context context;
    protected ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private OnDismissListener onDismissListener;
    private boolean dismissing;
    private Animation outAnim;
    private Animation inAnim;
    private boolean isShowing;
    private int gravity = 80;
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                BasePickerView.this.dismiss();
            }
            return false;
        }
    };

    public BasePickerView(Context context) {
        this.context = context;
        this.initViews();
        this.init();
        this.initEvents();
    }

    protected void initViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, this.decorView, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.isShowing = true;
        this.onAttached((View)this.rootView);
        this.rootView.requestFocus();
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null || this.isShowing;
    }

    public void dismiss() {
        if (this.dismissing) {
            return;
        }
        this.dismissing = true;
        this.outAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BasePickerView.this.decorView.post(new Runnable(){

                    @Override
                    public void run() {
                        BasePickerView.this.dismissImmediately();
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.contentContainer.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        this.decorView.removeView((View)this.rootView);
        this.isShowing = false;
        this.dismissing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public Animation getInAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public BasePickerView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    protected BasePickerView setOutSideCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
        return this;
    }

    public View findViewById(int id2) {
        return this.contentContainer.findViewById(id2);
    }
}

