/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import com.constantcontact.v2.Paged;
import com.constantcontact.v2.QueryDate;
import com.constantcontact.v2.contacts.Contact;
import com.constantcontact.v2.contacts.ContactList;
import com.constantcontact.v2.contacts.ContactStatus;
import com.constantcontact.v2.contacts.OptInSource;
import com.constantcontact.v2.contacts.SignupFormRequest;
import com.constantcontact.v2.contacts.SignupFormResponse;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface ContactService {
    public static final int MAX_PAGE_LIMIT = 500;
    public static final int DEFAULT_PAGE_LIMIT = 50;

    @GET(value="v2/contacts")
    public Call<Paged<Contact>> getContactsByEmail(@Query(value="email") String var1);

    @GET(value="v2/contacts")
    public Call<Paged<Contact>> getContacts(@Query(value="limit") int var1, @Query(value="status") ContactStatus var2);

    @GET(value="v2/contacts")
    public Call<Paged<Contact>> getContacts(@Query(value="limit") int var1, @Query(value="modified_since") QueryDate var2, @Query(value="status") ContactStatus var3);

    @GET(value="v2/lists/{listId}/contacts")
    public Call<Paged<Contact>> getContacts(@Path(value="listId") String var1, @Query(value="limit") int var2, @Query(value="modified_since") QueryDate var3);

    @GET
    public Call<Paged<Contact>> getContacts(@Url String var1);

    @POST(value="v2/contacts")
    public Call<Contact> createContact(@Body Contact var1, @Query(value="action_by") OptInSource var2);

    @GET(value="v2/contacts/{contactId}")
    public Call<Contact> getContact(@Path(value="contactId") String var1);

    @PUT(value="v2/contacts/{contactId}")
    public Call<Contact> updateContact(@Body Contact var1, @Path(value="contactId") String var2, @Query(value="action_by") OptInSource var3);

    @DELETE(value="v2/contacts/{contactId}")
    public Call<Response<Void>> unsubscribeContact(@Path(value="contactId") String var1);

    @GET(value="v2/lists")
    public Call<List<ContactList>> getContactLists(@Query(value="modified_since") QueryDate var1);

    @POST(value="v2/lists")
    public Call<ContactList> createContactList(@Body ContactList var1);

    @GET(value="v2/lists/{listId}")
    public Call<ContactList> getContactList(@Path(value="listId") String var1);

    @PUT(value="v2/lists/{listId}")
    public Call<ContactList> updateContactList(@Body ContactList var1, @Path(value="listId") String var2);

    @DELETE(value="v2/lists/{listId}")
    public Call<Response<Void>> deleteContactList(@Path(value="listId") String var1);

    @POST(value="v2/signupform")
    public Call<SignupFormResponse> createCustomSignupForm(@Body SignupFormRequest var1);
}

