/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import com.constantcontact.v2.Paged;
import com.constantcontact.v2.QueryDate;
import com.constantcontact.v2.campaigns.Campaign;
import com.constantcontact.v2.campaigns.CampaignPreview;
import com.constantcontact.v2.campaigns.CampaignSchedule;
import com.constantcontact.v2.campaigns.CampaignStatus;
import com.constantcontact.v2.campaigns.TestSend;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface CampaignService {
    public static final int MAX_PAGE_LIMIT = 50;
    public static final int DEFAULT_PAGE_LIMIT = 50;

    @GET(value="v2/emailmarketing/campaigns/{campaignId}")
    public Call<Campaign> getCampaign(@Path(value="campaignId") String var1, @Query(value="updateSummary") boolean var2);

    @GET(value="v2/emailmarketing/campaigns")
    public Call<Paged<Campaign>> getCampaigns(@Query(value="limit") int var1, @Query(value="status") CampaignStatus var2);

    @GET(value="v2/emailmarketing/campaigns")
    public Call<Paged<Campaign>> getCampaigns(@Query(value="limit") int var1, @Query(value="modified_since") QueryDate var2, @Query(value="status") CampaignStatus var3);

    @GET
    public Call<Paged<Campaign>> getCampaigns(@Url String var1);

    @POST(value="v2/emailmarketing/campaigns")
    public Call<Campaign> createCampaign(@Body Campaign var1);

    @PUT(value="v2/emailmarketing/campaigns/{campaignId}")
    public Call<Campaign> updateCampaign(@Body Campaign var1, @Path(value="campaignId") String var2);

    @DELETE(value="v2/emailmarketing/campaigns/{campaignId}")
    public Call<Response<Void>> deleteCampaign(@Path(value="campaignId") String var1);

    @POST(value="v2/emailmarketing/campaigns/{campaignId}/tests")
    public Call<TestSend> sendTestCampaign(@Body TestSend var1, @Path(value="campaignId") String var2);

    @GET(value="v2/emailmarketing/campaigns/{campaignId}/preview")
    public Call<CampaignPreview> getCampaignPreview(@Path(value="campaignId") String var1);

    @POST(value="v2/emailmarketing/campaigns/{campaignId}/schedules")
    public Call<CampaignSchedule> scheduleCampaign(@Body CampaignSchedule var1, @Path(value="campaignId") String var2);

    @GET(value="v2/emailmarketing/campaigns/{campaignId}/schedules")
    public Call<List<CampaignSchedule>> getCampaignSchedules(@Path(value="campaignId") String var1);

    @GET(value="v2/emailmarketing/campaigns/{campaignId}/schedules/{scheduleId}")
    public Call<CampaignSchedule> getCampaignSchedule(@Path(value="campaignId") String var1, @Path(value="scheduleId") String var2);

    @PUT(value="v2/emailmarketing/campaigns/{campaignId}/schedules/{scheduleId}")
    public Call<CampaignSchedule> updateCampaignSchedule(@Path(value="campaignId") String var1, @Path(value="scheduleId") String var2);

    @DELETE(value="v2/emailmarketing/campaigns/{campaignId}/schedules/{scheduleId}")
    public Call<Response<Void>> deleteCampaignSchedule(@Path(value="campaignId") String var1, @Path(value="scheduleId") String var2);
}

