/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import com.constantcontact.v2.converter.jackson.JacksonConverterFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class DefaultRetrofitBuilderFactory {
    public static final String BASE_URL = "https://api.constantcontact.com/";
    private final OkHttpClient _okHttpClient;

    @Inject
    public DefaultRetrofitBuilderFactory(@Named(value="ccapi2") OkHttpClient client) {
        this._okHttpClient = client;
    }

    public Retrofit.Builder create() {
        return this.create(BASE_URL);
    }

    public Retrofit.Builder create(String baseUrl) {
        return this.create(baseUrl, new ObjectMapper());
    }

    public Retrofit.Builder create(String baseUrl, ObjectMapper objectMapper) {
        return new Retrofit.Builder().baseUrl(baseUrl).client(this._okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create(objectMapper));
    }
}

