/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import com.constantcontact.v2.CCApiInterceptor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class DefaultOkHttpClientBuilderFactory {
    @Inject
    public DefaultOkHttpClientBuilderFactory() {
    }

    public OkHttpClient.Builder create(String apiKey, String token) {
        return this.create(apiKey, token, HttpLoggingInterceptor.Level.NONE);
    }

    public OkHttpClient.Builder create(String apiKey, String token, HttpLoggingInterceptor.Level loggingLevel) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().readTimeout(10L, TimeUnit.SECONDS).connectTimeout(5L, TimeUnit.SECONDS).addInterceptor((Interceptor)new CCApiInterceptor(apiKey, token));
        if (loggingLevel != HttpLoggingInterceptor.Level.NONE) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(loggingLevel);
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder;
    }
}

