/*
 * Decompiled with CFR 0.152.
 */
package com.constantcontact.v2;

import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class CCApiInterceptor
implements Interceptor {
    private final String _apiKey;
    private final String _token;

    public CCApiInterceptor(String apiKey, String token) {
        this._apiKey = apiKey;
        this._token = token;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        HttpUrl originalUrl = originalRequest.url();
        HttpUrl newUrl = originalUrl.newBuilder().addQueryParameter("api_key", this._apiKey).build();
        Request newRequest = originalRequest.newBuilder().url(newUrl).addHeader("Authorization", "Bearer " + this._token).addHeader("Content-Type", "application/json").addHeader("User-Agent", "Constant Contact Java Library v5.2.0").build();
        return chain.proceed(newRequest);
    }
}

