/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.endpoint.SeleniumBrowserConfiguration;
import java.util.Map;
import org.springframework.util.StringUtils;

public class SeleniumEndpointComponent
extends AbstractEndpointComponent {
    public SeleniumEndpointComponent() {
        super("selenium");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        SeleniumBrowser browser = new SeleniumBrowser();
        if (StringUtils.hasText((String)resourcePath) && !resourcePath.equals("browser")) {
            browser.getEndpointConfiguration().setBrowserType(resourcePath);
        }
        if (parameters.containsKey("start-page")) {
            browser.getEndpointConfiguration().setStartPageUrl(parameters.remove("start-page"));
        }
        if (parameters.containsKey("remote-server")) {
            browser.getEndpointConfiguration().setRemoteServerUrl(parameters.remove("remote-server"));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)browser.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, SeleniumBrowserConfiguration.class), context);
        return browser;
    }
}

