/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.config.annotation;

import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.selenium.config.annotation.SeleniumBrowserConfig;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.endpoint.SeleniumBrowserBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.support.events.WebDriverListener;
import org.springframework.util.StringUtils;

public class SeleniumBrowserConfigParser
implements AnnotationConfigParser<SeleniumBrowserConfig, SeleniumBrowser> {
    public SeleniumBrowser parse(SeleniumBrowserConfig annotation, ReferenceResolver referenceResolver) {
        SeleniumBrowserBuilder builder = new SeleniumBrowserBuilder();
        if (StringUtils.hasText((String)annotation.startPage())) {
            builder.startPage(annotation.startPage());
        }
        if (StringUtils.hasText((String)annotation.version())) {
            builder.version(annotation.version());
        }
        if (StringUtils.hasText((String)annotation.remoteServer())) {
            builder.remoteServer(annotation.remoteServer());
        }
        if (StringUtils.hasText((String)annotation.type())) {
            builder.type(annotation.type());
        }
        if (StringUtils.hasText((String)annotation.browserType())) {
            builder.browserType(annotation.browserType());
        }
        if (StringUtils.hasText((String)annotation.webDriver())) {
            builder.webDriver((WebDriver)referenceResolver.resolve(annotation.webDriver(), WebDriver.class));
        }
        if (StringUtils.hasText((String)annotation.firefoxProfile())) {
            builder.profile((FirefoxProfile)referenceResolver.resolve(annotation.firefoxProfile(), FirefoxProfile.class));
        }
        builder.eventListeners(referenceResolver.resolve(annotation.eventListeners(), WebDriverListener.class));
        builder.javaScript(annotation.javaScript());
        builder.timeout(annotation.timeout());
        return (SeleniumBrowser)builder.build();
    }
}

