/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.actions.NavigateAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import org.springframework.util.StringUtils;

public class StartBrowserAction
extends AbstractSeleniumAction {
    private final boolean allowAlreadyStarted;

    public StartBrowserAction(Builder builder) {
        super("start", builder);
        this.allowAlreadyStarted = builder.allowAlreadyStarted;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (!this.allowAlreadyStarted && browser.isStarted()) {
            this.log.warn("There are some open web browsers. They will be stopped.");
            browser.stop();
        } else if (browser.isStarted()) {
            this.log.info("Browser already started - skip start action");
            context.setVariable("selenium_browser", (Object)browser.getName());
            return;
        }
        this.log.info("Opening browser of type {}", (Object)browser.getEndpointConfiguration().getBrowserType());
        browser.start();
        if (StringUtils.hasText((String)this.getBrowser().getEndpointConfiguration().getStartPageUrl())) {
            NavigateAction openStartPage = new NavigateAction.Builder().page(this.getBrowser().getEndpointConfiguration().getStartPageUrl()).build();
            openStartPage.execute(browser, context);
        }
        context.setVariable("selenium_browser", (Object)browser.getName());
    }

    public boolean isAllowAlreadyStarted() {
        return this.allowAlreadyStarted;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<StartBrowserAction, Builder> {
        private boolean allowAlreadyStarted = true;

        public Builder allowAlreadyStarted(boolean permisson) {
            this.allowAlreadyStarted = permisson;
            return this;
        }

        public StartBrowserAction build() {
            return new StartBrowserAction(this);
        }
    }
}

