/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FindElementAction
extends AbstractSeleniumAction {
    private final By by;
    private final String property;
    private final String propertyValue;
    private String tagName;
    private Map<String, String> attributes = Collections.emptyMap();
    private Map<String, String> styles = Collections.emptyMap();
    private boolean displayed = true;
    private boolean enabled = true;
    private String text;

    public FindElementAction(Builder builder) {
        this("find", builder);
        this.attributes = builder.attributes;
        this.styles = builder.styles;
        this.displayed = builder.displayed;
        this.enabled = builder.enabled;
        this.text = builder.text;
    }

    public FindElementAction(String name, ElementActionBuilder<?, ?> builder) {
        super(name, builder);
        this.by = builder.by;
        this.property = builder.property;
        this.propertyValue = builder.propertyValue;
        this.tagName = builder.tagName;
    }

    @Override
    protected final void execute(SeleniumBrowser browser, TestContext context) {
        WebElement element = browser.getWebDriver().findElement(this.createBy(context));
        if (element == null) {
            throw new CitrusRuntimeException(String.format("Failed to find element '%s' on page", this.property + "=" + this.propertyValue));
        }
        this.validate(element, browser, context);
        this.execute(element, browser, context);
    }

    protected void validate(WebElement element, SeleniumBrowser browser, TestContext context) {
        this.validateElementProperty("tag-name", this.tagName, element.getTagName(), context);
        this.validateElementProperty("text", this.text, element.getText(), context);
        Assert.isTrue((this.displayed == element.isDisplayed() ? 1 : 0) != 0, (String)String.format("Selenium web element validation failed, property 'displayed' expected '%s', but was '%s'", this.displayed, element.isDisplayed()));
        Assert.isTrue((this.enabled == element.isEnabled() ? 1 : 0) != 0, (String)String.format("Selenium web element validation failed, property 'enabled' expected '%s', but was '%s'", this.enabled, element.isEnabled()));
        for (Map.Entry<String, String> attributeEntry : this.attributes.entrySet()) {
            this.validateElementProperty(String.format("attribute '%s'", attributeEntry.getKey()), attributeEntry.getValue(), element.getAttribute(attributeEntry.getKey()), context);
        }
        for (Map.Entry<String, String> styleEntry : this.styles.entrySet()) {
            this.validateElementProperty(String.format("css style '%s'", styleEntry.getKey()), styleEntry.getValue(), element.getCssValue(styleEntry.getKey()), context);
        }
    }

    private void validateElementProperty(String propertyName, String controlValue, String resultValue, TestContext context) {
        if (StringUtils.hasText((String)controlValue)) {
            String control = context.replaceDynamicContentInString(controlValue);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)control)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"payload", (String)resultValue, (String)control, (TestContext)context);
            } else {
                Assert.isTrue((boolean)control.equals(resultValue), (String)String.format("Selenium web element validation failed, %s expected '%s', but was '%s'", propertyName, control, resultValue));
            }
        }
    }

    protected void execute(WebElement element, SeleniumBrowser browser, TestContext context) {
        if (StringUtils.hasText((String)element.getTagName())) {
            context.setVariable(element.getTagName(), (Object)element);
        }
    }

    protected By createBy(TestContext context) {
        if (this.by != null) {
            return this.by;
        }
        switch (this.property) {
            case "id": {
                return By.id((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "class-name": {
                return By.className((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "link-text": {
                return By.linkText((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "css-selector": {
                return By.cssSelector((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "name": {
                return By.name((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "tag-name": {
                return By.tagName((String)context.replaceDynamicContentInString(this.propertyValue));
            }
            case "xpath": {
                return By.xpath((String)context.replaceDynamicContentInString(this.propertyValue));
            }
        }
        throw new CitrusRuntimeException("Unknown selector type: " + this.property);
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getStyles() {
        return this.styles;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getText() {
        return this.text;
    }

    public By getBy() {
        return this.by;
    }

    public static abstract class ElementActionBuilder<T extends FindElementAction, B extends ElementActionBuilder<T, B>>
    extends AbstractSeleniumAction.Builder<T, B> {
        protected By by;
        protected String property;
        protected String propertyValue;
        private String tagName;

        public B element(By by) {
            this.by = by;
            return (B)((Object)((ElementActionBuilder)this.self));
        }

        public B element(String property, String propertyValue) {
            this.property = property;
            this.propertyValue = propertyValue;
            return (B)((Object)((ElementActionBuilder)this.self));
        }

        public B tagName(String tagName) {
            this.tagName = tagName;
            return (B)((Object)((ElementActionBuilder)this.self));
        }
    }

    public static class Builder
    extends ElementActionBuilder<FindElementAction, Builder> {
        private Map<String, String> attributes = new HashMap<String, String>();
        private Map<String, String> styles = new HashMap<String, String>();
        private boolean displayed = true;
        private boolean enabled = true;
        private String text;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder attribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder style(String name, String value) {
            this.styles.put(name, value);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder displayed(boolean displayed) {
            this.displayed = displayed;
            return this;
        }

        public FindElementAction build() {
            return new FindElementAction(this);
        }
    }
}

